package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleModelCalendarPriceBiz;
import com.xxfc.platform.vehicle.pojo.vo.VehicleModelCalendarPriceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 17:35
 */
@RestController
@RequestMapping("/vehicle_model/calendar_price")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api(tags = "车型日历价格")
public class VehicleModelCalendarPriceController {

     private final VehicleModelCalendarPriceBiz vehicleModelCalendarPriceBiz;


     @ApiOperation("返回车型日历价格")
     @GetMapping("/list/vehicle_model/calendar_price/{vehicleModelId}/{type}")
     public ObjectRestResponse<VehicleModelCalendarPriceVo> listVehicleModelCalendarPriceByDateAndVehicleModelId(@RequestParam(value = "start",required = false) Date startDate,
                                                                                                                 @RequestParam(value = "end",required = false) Date endDate,
                                                                                                                 @PathVariable(value = "vehicleModelId") Integer vehicleModelId,
                                                                                                                 @PathVariable(value = "type")Integer type,
                                                                                                                 AppUserDTO appUserDTO){
          List<VehicleModelCalendarPriceVo> vehicleModelCalendarPriceVos = vehicleModelCalendarPriceBiz.listVehicleModelCalendarPriceByDateAndVehicleModelIdAndUserId(startDate,endDate,vehicleModelId,type,appUserDTO.getUserid());
          return ObjectRestResponse.succ(vehicleModelCalendarPriceVos);
     }
}
