package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.xxfc.platform.vehicle.entity.VehicleModelHolidayPrice;
import com.xxfc.platform.vehicle.mapper.VehicleModelHolidayPriceMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelHolidayPriceDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelHolidayPriceFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelHolidayPriceSaveDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleModelHolidayPriceVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 17:32
 */
@Transactional(rollbackFor = Exception.class)
@Service
public class VehicleModelHolidayPriceBiz extends BaseBiz<VehicleModelHolidayPriceMapper, VehicleModelHolidayPrice> {

    /**
     * 保存
     *
     * @param vehicleModelHolidayPriceSaveDTO
     * @param userId
     */
    public void addVehicleModelHolidayPrice(VehicleModelHolidayPriceSaveDTO vehicleModelHolidayPriceSaveDTO, Integer userId) {
        VehicleModelHolidayPrice vehicleModelHolidayPrice = new VehicleModelHolidayPrice();
        BeanUtils.copyProperties(vehicleModelHolidayPriceSaveDTO, vehicleModelHolidayPrice);
        //编辑
        if (Objects.nonNull(vehicleModelHolidayPriceSaveDTO.getId())) {
            vehicleModelHolidayPrice.setUpdTime(new Date());
            vehicleModelHolidayPrice.setUpdUserId(userId);
            int effect = mapper.updateByPrimaryKeySelective(vehicleModelHolidayPrice);
            if (effect < 1) {
                throw new BaseException("车型节假日设置失败");
            }
        } else {
            vehicleModelHolidayPrice.setCrtTime(new Date());
            vehicleModelHolidayPrice.setCrtUserId(userId);
            int effect = mapper.insertSelective(vehicleModelHolidayPrice);
            if (effect < 1) {
                throw new BaseException("车型节假日保存失败");
            }
        }
    }

    /**
     *
     * @param multiple 倍数
     * @param freeDays 免费天数
     * @param configDate 设置的日期*月份
     */
    public void updateVehicleModelHolidayPrice(Double multiple,Integer freeDays,Date configDate){
        VehicleModelHolidayPrice vehicleModelHolidayPrice = new VehicleModelHolidayPrice();
        vehicleModelHolidayPrice.setMultiple(multiple);
        vehicleModelHolidayPrice.setFreeDays(freeDays);
        Example example = new Example(VehicleModelHolidayPrice.class);
        Example.Criteria criteria = example.createCriteria();
        setCondtionDate(configDate,criteria);
        int effect = mapper.updateByExampleSelective(vehicleModelHolidayPrice,example);
        if (effect<1){
            throw new BaseException("车型节假日更新失败");
        }
    }

    /**
     * 按年 月 节假日 等条件查询
     *
     * @param vehicleModelHolidayPriceFindDTO
     * @return
     */
    public List<VehicleModelHolidayPriceVo> listVehicleModelHolidayPrice(VehicleModelHolidayPriceFindDTO vehicleModelHolidayPriceFindDTO) {
        List<VehicleModelHolidayPriceVo> vehicleModelHolidayPriceVos = new ArrayList<>();
        Example example = new Example(VehicleModelHolidayPrice.class);
        Example.Criteria criteria = example.createCriteria();
        setCondtionDate(vehicleModelHolidayPriceFindDTO.getDate(),criteria);
        if (StringUtils.isNotEmpty(vehicleModelHolidayPriceFindDTO.getFestival()) && vehicleModelHolidayPriceFindDTO.getFestival().trim().length() > 0) {
            criteria.andLike("festival", String.format("%%%s%%", vehicleModelHolidayPriceFindDTO.getFestival()));
        }
        List<VehicleModelHolidayPrice> holidayPrices = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(holidayPrices)) {
            return vehicleModelHolidayPriceVos;
        }
        VehicleModelHolidayPriceVo vehicleModelHolidayPriceVo;
        for (VehicleModelHolidayPrice holidayPrice : holidayPrices) {
            vehicleModelHolidayPriceVo = new VehicleModelHolidayPriceVo();
            BeanUtils.copyProperties(holidayPrice, vehicleModelHolidayPriceVo);
            vehicleModelHolidayPriceVos.add(vehicleModelHolidayPriceVo);
        }
        return vehicleModelHolidayPriceVos;
    }

    /**
     * 根据开始与结束时间查询
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public List<VehicleModelHolidayPriceDTO> findVehicleModelHolidayPriceByMonth(Date startDate, Date endDate) {
        List<VehicleModelHolidayPriceDTO> vehicleModelHolidayPriceDTOS = new ArrayList<>();
        Example example = new Example(VehicleModelHolidayPrice.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andBetween("festivalDay", startDate, endDate);
        List<VehicleModelHolidayPrice> modelHolidayPrices = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(modelHolidayPrices)) {
            return vehicleModelHolidayPriceDTOS;
        }
        VehicleModelHolidayPriceDTO vehicleModelHolidayPriceDTO;
        for (VehicleModelHolidayPrice modelHolidayPrice : modelHolidayPrices) {
            vehicleModelHolidayPriceDTO = new VehicleModelHolidayPriceDTO();
            BeanUtils.copyProperties(modelHolidayPrice, vehicleModelHolidayPriceDTO);
            vehicleModelHolidayPriceDTOS.add(vehicleModelHolidayPriceDTO);
        }
        return vehicleModelHolidayPriceDTOS;
    }

    /**
     * @param id
     * @return
     */
    public VehicleModelHolidayPriceSaveDTO findVehicleModelHolidayPriceById(Long id) {
        VehicleModelHolidayPrice vehicleModelHolidayPrice = mapper.selectByPrimaryKey(id);
        if (Objects.isNull(vehicleModelHolidayPrice)) {
            throw new BaseException("数据不存在");
        }
        VehicleModelHolidayPriceSaveDTO vehicleModelHolidayPriceSaveDTO = new VehicleModelHolidayPriceSaveDTO();
        BeanUtils.copyProperties(vehicleModelHolidayPrice, vehicleModelHolidayPriceSaveDTO);
        return vehicleModelHolidayPriceSaveDTO;
    }

    /**
     * 设置查询条件日期
     * @param conditionDate
     * @param criteria
     */
    private void setCondtionDate(Date conditionDate, Example.Criteria criteria){
        LocalDate localDate = LocalDate.from(conditionDate.toInstant());
        //开始日期
        Instant startInstant = localDate.withDayOfMonth(1).atStartOfDay(ZoneId.systemDefault()).toInstant();
        //结束日期
        LocalDate endLocalDate = localDate.with(TemporalAdjusters.lastDayOfMonth());
        Instant endInstant = endLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant();

        criteria.andBetween("festivalDay", Date.from(startInstant), Date.from(endInstant));
    }

}
