package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.admin.entity.BaseUserMember;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.entity.VehicleModelCalendarPrice;
import com.xxfc.platform.vehicle.mapper.VehicleModelCalendarPriceMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceSaveDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelHolidayPriceDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleModelCalendarPriceVo;
import com.xxfc.platform.vehicle.pojo.vo.VehicleModelDayPriceVo;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 17:32
 */
@Transactional(rollbackFor = Exception.class)
@Service
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class VehicleModelCalendarPriceBiz extends BaseBiz<VehicleModelCalendarPriceMapper, VehicleModelCalendarPrice> {
    /**
     * 一个星期的第一天
     */
    private static final int START_OF_WEEK = 1;
    /**
     * 一个星期的最后一天
     */
    private static final int END_OF_WEEK = 7;
    /**
     * 价格类型查询
     */
    private static final int PRICE_OF_TYPE = 0;
    /**
     * 天数类型查询
     */
    private static final int DAYS_OF_TYPE = 1;

    private final VehicleModelHolidayPriceBiz vehicleModelHolidayPriceBiz;
    private final VehicleModelBiz vehicleModelBiz;
    private final UserFeign userFeign;


    public void addVehicleModelCalendarPrice(List<VehicleModelCalendarPriceSaveDTO> vehicleModelCalendarPrices, Integer userId) {
        if (CollectionUtils.isNotEmpty(vehicleModelCalendarPrices)) {
            List<VehicleModelCalendarPrice> vehicleModelCalendarPriceList = new ArrayList<>();
            List<Date> dateList = vehicleModelCalendarPrices.stream().peek(x -> {
                VehicleModelCalendarPrice calendarPrice = new VehicleModelCalendarPrice();
                BeanUtils.copyProperties(x, calendarPrice);
                calendarPrice.setCrtTime(new Date());
                calendarPrice.setCrtUserId(userId);
                vehicleModelCalendarPriceList.add(calendarPrice);
            }).map(VehicleModelCalendarPriceSaveDTO::getVehicleModelDay).distinct().collect(Collectors.toList());

            //1.删除当月做更改了的日期的数据
            VehicleModelCalendarPrice vehicleModelCalendarPrice = new VehicleModelCalendarPrice();
            vehicleModelCalendarPrice.setUpdUserId(userId);
            vehicleModelCalendarPrice.setUpdTime(new Date());
            vehicleModelCalendarPrice.setIsDel(1);
            Example example = new Example(VehicleModelCalendarPrice.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("vehicleModelDay", dateList);
            mapper.updateByExample(vehicleModelCalendarPrice, example);
            //2.插入新的数据
            mapper.insertList(vehicleModelCalendarPriceList);
        }

    }

    public List<VehicleModelDayPriceVo> listVehicleModelPrice() {
        List<VehicleModelDayPriceVo> vehicleModelDayPriceVos = new ArrayList<>();
        List<VehicleModelDTO> vehicleModelDTOS = vehicleModelBiz.findAllVehicleModel();
        VehicleModelDayPriceVo vehicleModelDayPriceVo;
        for (VehicleModelDTO vehicleModelDTO : vehicleModelDTOS) {
            vehicleModelDayPriceVo = new VehicleModelDayPriceVo();
            BeanUtils.copyProperties(vehicleModelDTO, vehicleModelDayPriceVo);
            vehicleModelDayPriceVos.add(vehicleModelDayPriceVo);
        }
        return vehicleModelDayPriceVos;
    }

    public List<VehicleModelDayPriceVo> findVehicleModelcalendarPriceByDateWithDay(Date currentDate) {
        List<VehicleModelDayPriceVo> vehicleModelDayPriceVos = new ArrayList<>();
        Map<Integer, VehicleModelCalendarPrice> vehicleModelCalendarPriceMap = null;
        Example example = new Example(VehicleModelCalendarPrice.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("vehicleModelDay", currentDate);
        criteria.andEqualTo("isDel", 0);
        List<VehicleModelCalendarPrice> vehicleModelCalendarPriceList = mapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(vehicleModelCalendarPriceList)) {
            vehicleModelCalendarPriceMap = vehicleModelCalendarPriceList.stream().collect(Collectors.toMap(VehicleModelCalendarPrice::getVehicleModelId, Function.identity()));
        }
        List<VehicleModelDTO> vehicleModelDTOS = vehicleModelBiz.findAllVehicleModel();
        VehicleModelDayPriceVo vehicleModelDayPriceVo;
        for (VehicleModelDTO vehicleModelDTO : vehicleModelDTOS) {
            vehicleModelDayPriceVo = new VehicleModelDayPriceVo();
            BeanUtils.copyProperties(vehicleModelDTO, vehicleModelDayPriceVo);
            boolean isNullOfVehicleModelPrice = vehicleModelCalendarPriceMap == null ? true : vehicleModelCalendarPriceMap.get(vehicleModelDTO.getVehicleModelId()) == null;
            Double multiple = isNullOfVehicleModelPrice ? null : vehicleModelCalendarPriceMap.get(vehicleModelDTO.getVehicleModelId()).getMultiple();
            vehicleModelDayPriceVo.setMultiple(multiple);
            BigDecimal aPrice = isNullOfVehicleModelPrice ? null : vehicleModelCalendarPriceMap.get(vehicleModelDTO.getVehicleModelId()).getPrice();
            vehicleModelDayPriceVo.setPrice(aPrice);
            vehicleModelDayPriceVos.add(vehicleModelDayPriceVo);
        }
        return vehicleModelDayPriceVos;
    }


    public List<VehicleModelCalendarPriceSaveDTO> findVehicleModelCalendarPricesByDateWithMonth(Date currentDate) {
        List<VehicleModelCalendarPriceSaveDTO> vehicleModelCalendarPriceSaveDTOS = new ArrayList<>();
        Example example = new Example(VehicleModelCalendarPrice.class);
        Example.Criteria criteria = example.createCriteria();
        LocalDate startLocalDate = currentDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().withDayOfMonth(1);
        Date startDate = Date.from(startLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        LocalDate endLocalDate = startLocalDate.with(TemporalAdjusters.lastDayOfMonth());
        Date endDate = Date.from(endLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        criteria.andBetween("vehicleModelDay", startDate, endDate);
        criteria.andEqualTo("isDel", 0);
        List<VehicleModelCalendarPrice> vehicleModelCalendarPriceList = mapper.selectByExample(example);
        if (CollectionUtils.isEmpty(vehicleModelCalendarPriceList)) {
            return vehicleModelCalendarPriceSaveDTOS;
        }

        VehicleModelCalendarPriceSaveDTO vehicleModelCalendarPrice;
        for (VehicleModelCalendarPrice calendarPrice : vehicleModelCalendarPriceList) {
            vehicleModelCalendarPrice = new VehicleModelCalendarPriceSaveDTO();
            BeanUtils.copyProperties(calendarPrice, vehicleModelCalendarPrice);
            vehicleModelCalendarPriceSaveDTOS.add(vehicleModelCalendarPrice);
        }
        return vehicleModelCalendarPriceSaveDTOS;
    }

    public List<VehicleModelCalendarPriceDTO> findVehicleModelCalendarPriceByDateAndVehilceIdAndUserId(Date startDate, Date endDate, Integer vehicleModelId, Integer userId) {
        List<VehicleModelCalendarPriceDTO> vehicleModelCalendarPriceDTOS = new ArrayList<>();
        //车型的原价
        BigDecimal vehicle_price = new BigDecimal(0);
        Integer discount = 100;
        int free_days = 1;

        //日历价格转map
        List<VehicleModelCalendarPrice> vehicleModelCalendarPrices = getVehicleModelCalendarPricesByVehicleModelIdAndDate(vehicleModelId, startDate, endDate);
        Map<Date, VehicleModelCalendarPrice> calendarPriceMap = vehicleModelCalendarPrices.stream().collect(Collectors.toMap(VehicleModelCalendarPrice::getVehicleModelDay, Function.identity()));

        //节假日转map
        List<VehicleModelHolidayPriceDTO> vehicleModelHolidayPrices = vehicleModelHolidayPriceBiz.findVehicleModelHolidayPriceByMonth(startDate, endDate);
        Map<Date, VehicleModelHolidayPriceDTO> festivalDayMap = vehicleModelHolidayPrices.stream().collect(Collectors.toMap(VehicleModelHolidayPriceDTO::getFestivalDay, Function.identity()));

        vehicle_price = vehicleModelBiz.findVehicleModelPriceByVehicleModelId(vehicleModelId);
        if (Objects.nonNull(userId)) {
            BaseUserMember baseUserMember = userFeign.findBaseUserMemberByUserId(userId);
            discount = baseUserMember == null ? discount : baseUserMember.getDiscount();
        }

        VehicleModelCalendarPriceVo vehicleModelCalendarPriceVo;
        LocalDate final_startLocalDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate final_endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        VehicleModelCalendarPriceDTO vehicleModelCalendarPriceDTO;
        while (final_startLocalDate.isBefore(final_endLocalDate) || final_startLocalDate.isEqual(final_endLocalDate)) {
            vehicleModelCalendarPriceDTO = new VehicleModelCalendarPriceDTO();
            Date current_date = Date.from(final_startLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            vehicleModelCalendarPriceDTO.setBookDate(current_date);

            if (calendarPriceMap != null && !calendarPriceMap.isEmpty()) {
                VehicleModelCalendarPrice vehicleModelCalendarPrice = calendarPriceMap.get(Date.from(final_startLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
                if (Objects.isNull(vehicleModelCalendarPrice)) {
                    if (festivalDayMap != null && !festivalDayMap.isEmpty()) {
                        VehicleModelHolidayPriceDTO vehicleModelHolidayPriceDTO = festivalDayMap.get(current_date);
                        if (Objects.nonNull(vehicleModelHolidayPriceDTO)) {
                            vehicle_price = vehicle_price.multiply(new BigDecimal(vehicleModelHolidayPriceDTO.getMultiple().doubleValue() * (discount / 100)));
                            free_days = vehicleModelHolidayPriceDTO.getFreeDays();
                        }
                    }
                } else {
                    switch (vehicleModelCalendarPrice.getType()) {
                        case VehicleModelPriceType.MULTIPLE:
                            vehicle_price = vehicle_price.multiply(new BigDecimal(vehicleModelCalendarPrice.getMultiple().doubleValue() * (discount / 100)));
                            break;
                        case VehicleModelPriceType.ABS:
                            vehicle_price = vehicleModelCalendarPrice.getPrice().multiply(new BigDecimal(discount / 100));
                            break;
                        case VehicleModelPriceType.MEMBER:
                            //todo
                            break;
                        default:
                            break;
                    }
                    free_days = vehicleModelCalendarPrice.getFreeDays();
                }
            }
            vehicleModelCalendarPriceDTO.setFreeDays(free_days);
            vehicleModelCalendarPriceDTO.setPrice(vehicle_price);
            final_startLocalDate = final_startLocalDate.plusDays(1);
            vehicleModelCalendarPriceDTOS.add(vehicleModelCalendarPriceDTO);
        }
        return vehicleModelCalendarPriceDTOS;
    }

    /**
     * @param startDate
     * @param endDate
     * @param vehicleModelId
     * @param type
     * @return
     */
    public List<VehicleModelCalendarPriceVo> listVehicleModelCalendarPriceByDateAndVehicleModelIdAndUserId(Date startDate, Date endDate, Integer vehicleModelId, Integer type, Integer userId) {
        List<VehicleModelCalendarPriceVo> vehicleModelCalendarPriceVos = new ArrayList<>();
        //车型的原价
        BigDecimal vehicle_price = new BigDecimal(0);
        Integer discount = 100;
        int free_days = 1;

        AtomicReference<Date> startReference = new AtomicReference<>(startDate);
        AtomicReference<Date> endReference = new AtomicReference<>(endDate);
        transformStartDateAndEndDate(startReference, endReference);
        //处理后延伸的开始时间
        Date final_startDate = startReference.get();
        //处理后延伸的结束时间
        Date final_endDate = endReference.get();

        //日历价格转map
        List<VehicleModelCalendarPrice> vehicleModelCalendarPrices = getVehicleModelCalendarPricesByVehicleModelIdAndDate(vehicleModelId, final_startDate, final_endDate);
        Map<Date, VehicleModelCalendarPrice> calendarPriceMap = vehicleModelCalendarPrices.stream().collect(Collectors.toMap(VehicleModelCalendarPrice::getVehicleModelDay, Function.identity()));

        //节假日转map
        List<VehicleModelHolidayPriceDTO> vehicleModelHolidayPrices = vehicleModelHolidayPriceBiz.findVehicleModelHolidayPriceByMonth(final_startDate, final_endDate);
        Map<Date, VehicleModelHolidayPriceDTO> festivalDayMap = vehicleModelHolidayPrices.stream().collect(Collectors.toMap(VehicleModelHolidayPriceDTO::getFestivalDay, Function.identity()));

        if (type == PRICE_OF_TYPE) {
            vehicle_price = vehicleModelBiz.findVehicleModelPriceByVehicleModelId(vehicleModelId);
            if (Objects.nonNull(userId)) {
                BaseUserMember baseUserMember = userFeign.findBaseUserMemberByUserId(userId);
                discount = baseUserMember == null ? discount : baseUserMember.getDiscount();
            }
        }
        VehicleModelCalendarPriceVo vehicleModelCalendarPriceVo;
        LocalDate startLocalDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endLocalDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate final_startLocalDate = final_startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate final_endLocalDate = final_endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

        while (final_startLocalDate.isBefore(final_endLocalDate) || final_startLocalDate.isEqual(final_endLocalDate)) {
            vehicleModelCalendarPriceVo = new VehicleModelCalendarPriceVo();
            Date current_date = Date.from(final_startLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            vehicleModelCalendarPriceVo.setDate(current_date);
            if (final_startLocalDate.isAfter(startLocalDate) || final_startLocalDate.isEqual(startLocalDate) || final_startLocalDate.isEqual(endLocalDate)) {
                vehicleModelCalendarPriceVo.setIsSelect(true);
            } else {
                vehicleModelCalendarPriceVo.setIsSelect(false);
            }
            if (type == PRICE_OF_TYPE) {
                if (calendarPriceMap != null && !calendarPriceMap.isEmpty()) {
                    VehicleModelCalendarPrice vehicleModelCalendarPrice = calendarPriceMap.get(current_date);
                    if (Objects.isNull(vehicleModelCalendarPrice)) {
                        if (festivalDayMap != null && !festivalDayMap.isEmpty()) {
                            VehicleModelHolidayPriceDTO vehicleModelHolidayPriceDTO = festivalDayMap.get(current_date);
                            if (Objects.nonNull(vehicleModelHolidayPriceDTO)) {
                                vehicle_price = vehicle_price.multiply(new BigDecimal(vehicleModelHolidayPriceDTO.getMultiple().doubleValue() * (discount / 100)));
                            }
                        }
                    } else {
                        switch (vehicleModelCalendarPrice.getType()) {
                            case VehicleModelPriceType.MULTIPLE:
                                vehicle_price = vehicle_price.multiply(new BigDecimal(vehicleModelCalendarPrice.getMultiple().doubleValue() * (discount / 100)));
                                break;
                            case VehicleModelPriceType.ABS:
                                vehicle_price = vehicleModelCalendarPrice.getPrice().multiply(new BigDecimal(discount / 100));
                                break;
                            case VehicleModelPriceType.MEMBER:
                                //todo
                                break;
                            default:
                                break;
                        }

                    }
                }
                vehicleModelCalendarPriceVo.setPrice(vehicle_price);
            }
            if (type == DAYS_OF_TYPE) {
                if (calendarPriceMap != null && !calendarPriceMap.isEmpty()) {
                    VehicleModelCalendarPrice vehicleModelCalendarPrice = calendarPriceMap.get(current_date);
                    if (Objects.isNull(vehicleModelCalendarPrice)) {
                        if (festivalDayMap != null && !festivalDayMap.isEmpty()) {
                            VehicleModelHolidayPriceDTO vehicleModelHolidayPriceDTO = festivalDayMap.get(current_date);
                            if (Objects.nonNull(vehicleModelHolidayPriceDTO)) {
                                free_days = vehicleModelHolidayPriceDTO.getFreeDays();
                            }
                        }
                    } else {
                        free_days = vehicleModelCalendarPrice.getFreeDays();
                    }
                }
                vehicleModelCalendarPriceVo.setDays(free_days);
            }
            final_startLocalDate = final_startLocalDate.plusDays(1);
            vehicleModelCalendarPriceVos.add(vehicleModelCalendarPriceVo);
        }
        return vehicleModelCalendarPriceVos;
    }

    private List<VehicleModelCalendarPrice> getVehicleModelCalendarPricesByVehicleModelIdAndDate(Integer vehicleModelId, Date final_startDate, Date final_endDate) {
        Example example = new Example(VehicleModelCalendarPrice.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel", 0);
        criteria.andEqualTo("vehicleModelId", vehicleModelId);
        criteria.andBetween("vehicleModelDay", final_startDate, final_endDate);
        List<VehicleModelCalendarPrice> vehicleModelCalendarPrices = mapper.selectByExample(example);
        return CollectionUtils.isEmpty(vehicleModelCalendarPrices) ? Collections.EMPTY_LIST : vehicleModelCalendarPrices;
    }

    public static void transformStartDateAndEndDate(AtomicReference<Date> startDatee, AtomicReference<Date> endDatee) {
        Date startDate = startDatee.get();
        Date endDate = endDatee.get();
        if (startDate == null && endDate == null) {
            LocalDate now = LocalDate.now();
            LocalDate endLocalDate = now.with(TemporalAdjusters.lastDayOfMonth());
            LocalDate startLocalDate = now.withDayOfMonth(1);
            startDate = Date.from(startLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            endDate = Date.from(endLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());

        } else {
            /****************************************开始时间处理******************************************************/
            LocalDate startLocalDate = LocalDate.from(startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            int start_dayOfMonth = startLocalDate.getDayOfMonth();
            int start_week = startLocalDate.getDayOfWeek().getValue();
            if (START_OF_WEEK < start_week && start_week < END_OF_WEEK) {
                start_dayOfMonth = start_dayOfMonth - (start_week - START_OF_WEEK);
            } else {
                if (END_OF_WEEK == start_week) {
                    start_dayOfMonth = start_dayOfMonth - END_OF_WEEK + 1;
                } else {
                    start_dayOfMonth = START_OF_WEEK;
                }
            }
            start_dayOfMonth = start_dayOfMonth > 0 ? start_dayOfMonth : 1;
            LocalDate start_startLocalDate = startLocalDate.withDayOfMonth(start_dayOfMonth);

            /****************************************结束时间处理******************************************************/
            LocalDate endLocalDate = LocalDate.from(endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            int end_dayOfMonth = endLocalDate.getDayOfMonth();
            int end_week = endLocalDate.getDayOfWeek().getValue();
            int last_day = endLocalDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
            if (START_OF_WEEK < end_week && end_week < END_OF_WEEK) {
                end_dayOfMonth = end_dayOfMonth + (END_OF_WEEK - end_week);
            } else {
                if (START_OF_WEEK == end_week) {
                    end_dayOfMonth = end_dayOfMonth + END_OF_WEEK - 1;
                }
            }
            end_dayOfMonth = end_dayOfMonth > last_day ? last_day : end_dayOfMonth;
            LocalDate end_endLocalDate = endLocalDate.withDayOfMonth(end_dayOfMonth);

            /****************************************时间转换******************************************************/
            startDate = Date.from(start_startLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            endDate = Date.from(end_endLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        startDatee.set(startDate);
        endDatee.set(endDate);
    }


    /**
     * 车型日历价格设置类型
     */
    private class VehicleModelPriceType {
        /**
         * 倍数
         */
        private static final int MULTIPLE = 0;
        /**
         * 绝对值
         */
        private static final int ABS = 1;
        /**
         * 会员价
         */
        private static final int MEMBER = 2;
    }
}
