package com.xxfc.platform.vehicle.pojo.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 17:11
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
public class VehicleModelCalendarPriceSaveDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    /**
     * 日期设置
     */
    private Date vehicleModelDay;
    /**
     * 是否全局设置
     */
    private Boolean isGlobal;
    /**
     * 车型id
     */
    private Integer vehicleModelId;
    /**
     * 1：倍数 2：绝对值  3：会员价
     */
    private Integer type;
    /**
     * 倍数
     */
    private Double multiple;
    /**
     * 抵扣天数
     */
    private Integer freeDays;
    /**
     * 绝对值 或会员价
     */
    private BigDecimal price;

}
