package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.activity.biz.ActivityPopularizeRelationBiz;
import com.xxfc.platform.activity.dto.ActivityPopularizeRelationDTO;
import com.xxfc.platform.activity.entity.ActivityPopularizeRelation;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("activityPopularizeRelation")
public class ActivityPopularizeRelationController extends BaseController<ActivityPopularizeRelationBiz,ActivityPopularizeRelation> {


    @GetMapping("/activity_popularize")
    public List<ActivityPopularizeRelationDTO> findActivityPopularizeRelationByActivityIdAndTime(@RequestParam(value = "activityId") Integer activityId,
                                                                                                 @RequestParam(value = "startTime",required = false) Long startTime,
                                                                                                 @RequestParam(value = "endTime",required = false) Long endTime){
        return baseBiz.findActivityPopularizeRelationsByActivityIdAndTime(activityId,startTime,endTime);
    }

}