package com.github.wxiaoqi.security.common.util;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringToolsUtil {

    /**
     * 验证手机号码
     * @param mobiles
     * @return
     */
    public static boolean isMobileNO(  String mobiles){
        boolean flag = false;
        try{
            if(StringUtils.isBlank(mobiles)) {
                flag = false;
            }
            Pattern regex = Pattern.compile("^((16[0-9])|(13[0-9])|(15[^4,\\D])|(17[0-9])|(18[0-9])|(19[0-9]))\\d{8}$");
            Matcher m = regex .matcher(mobiles);
            flag = m.matches();
        }catch(Exception e){
            flag = false;
        }
        return flag;
    }

    /**
     * 校验身份证
     *
     * @param idCard
     * @return 校验通过返回true，否则返回false
     */
    public static boolean isIDCard(String idCard) {
        if(StringUtils.isBlank(idCard)) {
            return false;
        }
        String REGEX_ID_CARD = "(^\\d{18}$)|(^\\d{15}$)";
        return Pattern.matches(REGEX_ID_CARD, idCard);
    }
}
