package com.xxfc.platform.vehicle.mapper;

import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.pojo.*;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePlanDto;
import com.xxfc.platform.vehicle.pojo.vo.UsableVeicleVO;
import org.apache.ibatis.annotations.Select;
import org.springframework.data.repository.query.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.Map;

public interface VehicleMapper extends Mapper<Vehicle> {

    public   List<ResultVehicleVo> getByPage(Map<String, Object> params);

    public   List<ResultVehicleVo> getByPageNotAllData(Map<String, Object> params);



    public int updateStatusById(Map<String, Object> params);

    /**
     * 锁定相关编码 或 车牌 的行
     *
     * @param addOrUpdateVehicleVo
     * @return
     */
    public List<Vehicle> lockByCode(AddOrUpdateVehicleVo addOrUpdateVehicleVo);

    int updateStatusByIdAndStatus(@Param("vehicleId") String vehicleId, @Param("status") Integer status,
                                  @Param("lastStatus") Integer lastStatus);

    int updateStatus(@Param("vehicleId") String vehicleId, @Param("status") Integer status);

    Vehicle selectByNumberPlate(String numberPlate);

    List<UsableVehicleModelVO> searchUsableModel(Map<String, Object> params);

    List<UsableVeicleVO> searchUsableVehicle(Map<String, Object> params);

    List<VehicleCountVo> countVehicleByParam(VehiclePlanDto vehiclePlanDto);

    List<VehicleAndModelInfoVo> getAllVehicle(Map<String, Object> params);

    List<VehicleAndModelInfoVo> getVehicle(Map<String, Object> params);
    //保养结束
    int updateMileageStatusByIdAndStatus(@Param("vehicleId") String vehicleId, @Param("status") Integer status,
                                         @Param("lastStatus") Integer lastStatus,@Param("mileage") Integer mileage);
    //开始保养
    int upMileageByIdAndStatus(@Param("vehicleId") String vehicleId, @Param("status") Integer status,
                               @Param("lastStatus") Integer lastStatus,@Param("mileage") Integer mileage);

    @Select("select `id` from `vehicle` where `is_del`=0")
    List<String> findExistVehicleIds();

    List<BranchCompanyVehicleCountVo> getAllVehicleInfo();

    List<Vehicle> getAllVehicleByParam(Map<String, Object> param);
}