package com.xxfc.platform.vehicle.biz;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.mapper.BranchCompanyApplyMapper;
import com.xxfc.platform.vehicle.pojo.dto.BranchCompanyApplyFindDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;


@Service
@Slf4j
public class BranchCompanyApplyBiz extends BaseBiz<BranchCompanyApplyMapper, BranchCompanyApply>{



    public ObjectRestResponse addOrUpd(BranchCompanyApply branchCompanyApply){
        Long id = branchCompanyApply.getId() == null ? 0L :branchCompanyApply.getId();
        if (id > 0L){
             updateSelectiveById(branchCompanyApply);
        }else {
             insertSelective(branchCompanyApply);
        }
        return  ObjectRestResponse.succ();
    }

    public List<BranchCompanyApply> getList(BranchCompanyApplyFindDTO applyFindDTO){
        Example example=new Example(BranchCompanyApply.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);
        if (applyFindDTO.getStatus() != null ){
            criteria.andEqualTo("status",applyFindDTO.getStatus());
        }
        if (applyFindDTO.getType() != null ){
            criteria.andEqualTo("type",applyFindDTO.getType());
        }
        if (applyFindDTO.getStartTime() != null && applyFindDTO.getStartTime() > 0 ){
            criteria.andGreaterThanOrEqualTo("crtTime",applyFindDTO.getStartTime());
        }
        if (applyFindDTO.getEndTime() != null && applyFindDTO.getEndTime() > 0 ){
            criteria.andLessThanOrEqualTo("crtTime",applyFindDTO.getEndTime());
        }
        example.setOrderByClause("crt_time desc ");

        return  selectByExample(example);
    }

    public ObjectRestResponse selectList(BranchCompanyApplyFindDTO applyFindDTO){
        PageHelper.startPage(applyFindDTO.getPage(), applyFindDTO.getLimit());
        PageInfo<BranchCompanyApply> pageInfo = new PageInfo<>(getList(applyFindDTO));
        return ObjectRestResponse.succ(PageDataVO.pageInfo(pageInfo));
    }


}
