package com.xxfc.platform.vehicle.pojo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;


@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class VehicleExcelVo {
    private static Map<Integer, String> map = new HashMap();

    static {
        map.put(1, "正常运行");
        map.put(3, "报废");
        map.put(4, "出车");
        map.put(6, "维修");
        map.put(7, "保养");
        map.put(8, "上牌");
    }

    /**
     * 车牌号，空字符串-没有
     */
    private String numberPlate;


    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车型
     */
    private String vehicleType;


    /**
     * 用途名称
     */
    private String useTypeName;


    /**
     * 停靠分支机构（名）
     */

    private String parkBranchCompanyName;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 所属人 名称
     */
    private String belongToName;

    /**
     * 车架号
     */
    private String vin;

    /**
     * 发动机号
     */
    private String engineNum;


    /**
     * 商业险公司，见常量表
     */
    private String insuranceCompany;


    /**
     * 商业险单号
     */
    private String insuranceNo;


    /**
     * 所属公司名称
     */
    private String companyName;


    /**
     *  商业险结束时间
     */
    private Date insuranceEndDate;

    /**
     * 交强险公司
     */
    private String strongInsuranceCompany;

    /**
     * 交强险单号
     */
    private String strongInsuranceNo;

    /**
     * 交强险时间
     */
    private Date strongInsuranceEndDate;




    public String getStatus() {
        return map.get(status);
    }
}
