package com.xxfc.platform.vehicle.pojo;

import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

@Data
public class ResultVehicleVo {
    /**
     * 主键(uuid)
     */
    private String id;

    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 车牌号，空字符串-没有
     */
    private String numberPlate;


    /**
     * 车型
     */
    private String vehicleType;

    /**
     * 品牌（编码，对应关系见相关常量），0-未填写
     */
    private Integer brand;

    /**
     * 所属分支机构（id）
     */
    private Integer subordinateBranch;
    /**
     * 所属分支机构（名称）
     */
    private String subBranchName;

    /**
     * 停靠分支机构（id）
     */
    private Integer parkBranchCompanyId;
    /**
     * 停靠分支机构（名称）
     */
    private String parkBranchCompanyName;

    /**
     * 所属公司名称
     */
    private String companyName;

    /**
     * 目的地分支机构（id）
     */
    private Integer expectDestinationBranchCompanyId;
    /**
     * 目的地分支机构（名称）
     */
    private String expectDestinationBranchCompanyName;


    /**
     * 用途类型：租赁房车（1）、展车等，对应关系见车辆常量表
     */
    private Integer useType;


    /**
     * 用途名称
     */
    private String useTypeName;

    /**
     * 备注信息
     */
    private String remark;

    private Date createTime;

    private Date updateTime;

    /**
     * 车架号
     */
    private String vin;



    /**
     * 商业险公司，见常量表
     */
    private Integer insuranceCompany;


    /**
     * 商业险单号
     */
    private String insuranceNo;

    /**
     *  商业险开始时间
     */
    private Date insuranceStartDate;

    /**
     *  商业险结束时间
     */
    private Date insuranceEndDate;

    /**
     * 交强险公司
     */
    private Integer strongInsuranceCompany;

    /**
     * 交强险单号
     */
    private String strongInsuranceNo;

    /**
     * 交强险时间
     */
    private Date strongInsuranceEndDate;

    /**
     * 年审时间
     */
    private Date annualVerificationDate;

    /**
     * 保养时间
     */
    private Date maintenanceDate;
    /**
     * 当前公里数
     */
    private Integer mileage;

    /**
     * 保养里程数
     */
    private Integer maintenanceMileage;

    /**
     * 车辆所属人-类型
     */
    private Integer belongTo;

    /**
     * 所属人 名称
     */
    private String belongToName;

    /**
     * 行驶证路径
     */
    private String drivingLicensePath;


    /**
     * 发动机号
     */
    private String engineNum;

    /**
     * 生产商
     */
    private String manufacturer;

    /**
     * 收车时间
     */
    private Date receiveTime;

    private Integer modelId;


    /**
     * 是否能用会员：1、所有会员，2、充值会员，3、兑换会员，4、禁用会员
     */
    @Column(name = "member_use")
    private Integer memberUse;

    /**
     * 车辆状况：1、全新，2、9成新，3、8成新，4、7成新
     */
    @Column(name = "vehicle_status")
    private Integer vehicleStatus;

    /**
     * 车身状况：1、无剐蹭，2、微瑕疵，3、无瑕疵
     */
    @Column(name = "vehicle_body_status")
    private Integer vehicleBodyStatus;

    /**
     * 内饰：1、全新，2、9成新，3、8成新，4、7成新
     */
    @Column(name = "vehicle_inner_status")
    private Integer vehicleInnerStatus;
}