package com.xxfc.platform.vehicle.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

@Data
public class AddOrUpdateVehicleVo {

    /**
     * 主键(uuid)
     */
    private String id;


    /**
     * 车辆状态： 1-正常运行 2-维修 3-报废
     */
    private Integer status;

    /**
     * 车辆编号，0-没有
     */
    private Integer code;

    /**
     * 车牌号，空字符串-没有
     */
    @Column(name = "number_plate")
    private String numberPlate;

    /**
     * 品牌（编码，对应关系见相关常量），0-未填写
     */
    private Integer brand;

    /**
     * 所属分支机构（id）
     */
    @Column(name = "subordinate_branch")
    private Integer subordinateBranch;


    /**
     * 停车分公司（id）
     */
    @Column(name = "park_branch_company_id")
    private Integer parkBranchCompanyId;

    /**
     * 用途类型：租赁房车（1）、展车等，对应关系见车辆常量表
     */
    @Column(name = "use_type")
    private Integer useType;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 车架号
     */
    private String vin;

    /**
     * 保险公司，见常量表
     */
    private Integer insuranceCompany;
    private Integer strongInsuranceCompany;


    /**
     * 保险单号
     */
    private String insuranceNo;
    private String strongInsuranceNo;

    /**
     * 保险开始时间
     */
    private Date insuranceStartDate;

    /**
     * 保险结束时间
     */
    private Date insuranceEndDate;
    private Date strongInsuranceEndDate;

    /**
     * 年审时间
     */
    private Date annualVerificationDate;

    /**
     * 保养时间
     */
    private Date maintenanceDate;

    /**
     * 保养里程数
     */
    private Integer maintenanceMileage;

    /**
     * 车辆所属人-类型
     */
    private Integer belongTo;

    /**
     * 所属人 名称
     */
    private String belongToName;

    /**
     * 行驶证路径
     */
    private String drivingLicensePath;

    /**
     * 行驶副本
     */
    private String drivingLicenseDuplicatePath;

    /**
     * 发动机号
     */
    private String engineNum;

    /**
     * 生产商
     */
    private String manufacturer;

    /**
     * 生产商
     */
    private Date receiveTime;

    /**
     * 最后公里数
     */
    private Integer mileageLastUpdate;

    /**
     * 车型
     */
    private Integer modelId;
    /**
     * 车辆状态
     */
    private Integer travelStatus;

    /**
     * 终端号
     */
    private String terminalNumber;

    /**
     * SIM卡号
     */
    private String simNumber;

    /**
     * 通讯类型
     */
    private String communicationType;

    /**
     * 电子保单
     */
    private String insurancePDF;

    //可用会员类型
    private Integer memberUse;

    /**
     * 车辆状况：1、全新，2、9成新，3、8成新，4、7成新
     */
    private Integer vehicleStatus;

    /**
     * 车身状况：1、无剐蹭，2、微瑕疵，3、无瑕疵
     */
    private Integer vehicleBodyStatus;

    /**
     * 内饰：1、全新，2、9成新，3、8成新，4、7成新
     */
    private Integer vehicleInnerStatus;

    /**
     * 上牌日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date vehicleRegisterDate;

    private String registerDate;


}