package com.xxfc.platform.vehicle.constant;

import java.util.HashMap;
import java.util.Map;

public enum VehicleMemberType {
	ALL(1,"所有会员"),
	PAY(2,"兑换会员"),
	EXCHANGE(3,"兑换会员"),
	NO(4, "禁用会员")
	;
	/**
	 * 编码
	 */
	private Integer code;
	/**
	 * 类型描述
	 */
	private String desc;

	private static Map<Integer,String> codeAndDesc = new HashMap<Integer, String>();
	//Maps.newHashMap();

	static{
		for(VehicleMsgType constantType : VehicleMsgType.values()){
			codeAndDesc.put(constantType.getCode(),constantType.getDesc());
		}
	}

	VehicleMemberType(Integer code, String desc){
		this.code=code;
		this.desc=desc;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public static Boolean exists(Integer code){
		return codeAndDesc.containsKey(code);
	}
}
