package com.xxfc.platform.order.rest.background;

import cn.hutool.core.io.IoUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.biz.DailyMembersOrderStatisticsBiz;
import com.xxfc.platform.order.biz.DailyTravelOrderStatisticsBiz;
import com.xxfc.platform.order.biz.DailyVehicleOrderStatisticsBiz;
import com.xxfc.platform.order.biz.OrderStatisticsBiz;
import com.xxfc.platform.order.entity.OrderStatistics;
import com.xxfc.platform.order.pojo.MembersOrderDto;
import com.xxfc.platform.order.pojo.OrderQuery;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("/background/statistics")
@Api(description = "每月总的订单统计")
public class BgStatisticsController extends BaseController<OrderStatisticsBiz, OrderStatistics> {

    @GetMapping("/indexOrder")
    @ApiOperation(value = "首页订单统计")
    public ObjectRestResponse<IndexOrderVO> indexOrder()  {
        IndexOrderVO indexOrderVO = new IndexOrderVO();
        indexOrderVO.setCurrDayOrderAmount(new BigDecimal("1000000000.00"));
        indexOrderVO.setCurrDayOrderNum(2L);
        indexOrderVO.setCurrDayToLiftVehicleNum(3L);
        indexOrderVO.setCurrDayToReturnVehicleNum(4L);
        indexOrderVO.setToDealTrafficPay(5L);
        //获取会员订单统计信息
        return ObjectRestResponse.succ(indexOrderVO);
    }

    @Data
    public static class IndexOrderVO {
        private BigDecimal currDayOrderAmount;
        private Long currDayOrderNum;
        private Long currDayToLiftVehicleNum;
        private Long currDayToReturnVehicleNum;
        private Long toDealTrafficPay;
    }
}
