package com.xxfc.platform.order.mapper;

import com.xxfc.platform.order.bo.CompanyPerformanceBo;
import com.xxfc.platform.order.entity.OrderReceivedStatistics;
import com.xxfc.platform.order.pojo.dto.CompanyPerformanceFindDTO;
import com.xxfc.platform.order.pojo.dto.OrderReceivedStatisticsFindDTO;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.additional.insert.InsertListMapper;
import tk.mybatis.mapper.common.Mapper;

import java.util.Date;
import java.util.List;

/**
 *  全部订单统计
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-11-08 18:03:42
 */
public interface OrderReceivedStatisticsMapper extends Mapper<OrderReceivedStatistics>, InsertListMapper<OrderReceivedStatistics> {

    List<OrderReceivedStatistics> selectOrderReceivedStatisticsDateList(OrderReceivedStatisticsFindDTO orderReceivedStatisticsFindDTO);
    List<OrderReceivedStatistics> selectOrderReceivedStatisticsMonthList(OrderReceivedStatisticsFindDTO orderReceivedStatisticsFindDTO);
    List<OrderReceivedStatistics> selectOrderReceivedStatisticsWeekOfYearList(OrderReceivedStatisticsFindDTO orderReceivedStatisticsFindDTO);

    List<CompanyPerformanceBo> selectCompanyPerformanceWithDay(CompanyPerformanceFindDTO companyPerformanceFindDTO);

    List<CompanyPerformanceBo> selectCompanyPerformanceWithMonth(CompanyPerformanceFindDTO companyPerformanceFindDTO);

    List<CompanyPerformanceBo> selectCompanyPerformanceWithWeek(CompanyPerformanceFindDTO companyPerformanceFindDTO);

    int selectCountByDate(CompanyPerformanceFindDTO companyPerformanceFindDTO);
    int selectCountByMonth(CompanyPerformanceFindDTO companyPerformanceFindDTO);
    int selectCountByWeekOfYear(CompanyPerformanceFindDTO companyPerformanceFindDTO);

    List<OrderReceivedStatistics> findOrderReceivedStatisticsByDate(@Param("startDate") Date startDate,
                                                                    @Param("endDate") Date endDate);
}
