package com.xxfc.platform.order.mapper;


import com.xxfc.platform.order.entity.CompanyWalletDetail;
import com.xxfc.platform.order.pojo.dto.WalletDetailDTO;
import com.xxfc.platform.order.pojo.vo.CompanyWalletDetailVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * 收入/支持明细表，每笔的进账，出账的详细记录
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
public interface CompanyWalletDetailMapper extends Mapper<CompanyWalletDetail> {


    @Select("SELECT IFNULL(SUM(amount),0)+IFNULL((SELECT balance FROM company_wallet WHERE company_id = #{companyId}),0) FROM company_wallet_detail WHERE cono=#{no} and company_id = #{companyId}")
    BigDecimal sumAmountByNo(@Param("no")String no,@Param("companyId")Integer companyId);

    List<CompanyWalletDetailVo> selectList(WalletDetailDTO walletDetailDTO);

    BigDecimal sumAmount(WalletDetailDTO walletDetailDTO);


}
