package com.xxfc.platform.order.mapper;


import com.xxfc.platform.order.entity.CompanyWalletCath;
import com.xxfc.platform.order.pojo.dto.WalletCathDTO;
import com.xxfc.platform.order.pojo.vo.CompanyWalletCathVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;


/**
 * 钱包提现表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
public interface CompanyWalletCathMapper extends Mapper<CompanyWalletCath> {

    List<CompanyWalletCathVo> selectList(WalletCathDTO walletCathDTO);

    @Select("SELECT IFNULL(SUM(amount),0) FROM company_wallet_cath WHERE company_id =#{companyId} AND stauts=0")
    BigDecimal sunAmountByStatus(@Param("companyId")Integer companyId);

}
