package com.xxfc.platform.order.biz;

import cn.hutool.core.util.StrUtil;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderTourDetail;
import com.xxfc.platform.order.mapper.OrderTourVerificationMapper;
import com.xxfc.platform.order.pojo.mq.OrderMQDTO;
import com.xxfc.platform.order.pojo.order.OrderTourVerificationVO;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

import static com.xxfc.platform.order.pojo.pay.NotifyUrlDTO.PAY_WAY_ALI;

/**
 * 旅游订单核销
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 18:18:33
 */
@Service
public class OrderTourVerificationBiz{


    @Autowired
    private OrderTourVerificationMapper verificationMapper;
    @Autowired
    private BaseOrderBiz baseOrderBiz;
    @Autowired
    private OrderTourDetailBiz tourDetailBiz;
    @Autowired
    private OrderAccountBiz orderAccountBiz;

    @Autowired
    private TourFeign tourFeign;

    /**
     * 分页查询旅游订单核销列表
     * @param page
     * @param limit
     * @return
     */
    public PageDataVO<OrderTourVerificationVO> getVerificationList(Integer page, Integer limit,Integer verificationId){

        return  PageDataVO.pageInfo(page,limit,()->verificationMapper.pageByParm(verificationId));
    }

    /**
     *
     * @param no  订单号
     * @param list  分公司列表
     * @param userDTO
     * @return
     */
    //核销
    public ObjectRestResponse VerificationByOrder(String no, List<BranchCompany> list, UserDTO userDTO){
        BaseOrder baseOrder=new BaseOrder();
        baseOrder.setNo(no);
         baseOrder=baseOrderBiz.selectOne(baseOrder);
        if(baseOrder==null){
            return ObjectRestResponse.createFailedResult(ResCode.ORDER_IS_NOT_EXIST.getCode(), ResCode.ORDER_IS_NOT_EXIST.getDesc());
        }
        if(baseOrder.getHasPay()==0){
            return ObjectRestResponse.createFailedResult(ResCode.ORDER_IS_NOT_PAY.getCode(), ResCode.ORDER_IS_NOT_PAY.getDesc());
        }
        if (baseOrder.getStatus()==6){
            return ObjectRestResponse.createFailedResult(ResCode.ORDER_HAS_FINISH.getCode(),"二维码不能重复使用");
        }
       Integer orderId=baseOrder.getId();
        Integer version=baseOrder.getVersion();
        OrderTourDetail tourDetail=new OrderTourDetail();
        tourDetail.setOrderId(orderId);
        tourDetail=tourDetailBiz.selectOne(tourDetail);
        if(tourDetail==null){
            return ObjectRestResponse.createFailedResult(ResCode.ORDER_IS_NOT_EXIST.getCode(), ResCode.ORDER_IS_NOT_EXIST.getDesc());
        }
        Integer verificationId=tourDetail.getVerificationId();
        Integer total_number=tourDetail.getTotalNumber();
        if(userDTO.getDataAll()==2){
            Integer companyId=tourDetail.getStartCompanyId();
            if(companyId!=null){
                boolean falg=isPower(list,companyId);
                if(!falg){
                    return ObjectRestResponse.createFailedResult(ResCode.YOU_AUTH_FAIL.getCode(), ResCode.YOU_AUTH_FAIL.getDesc());

                }
            }
        }

        // 出发时间 是否已经发车
        Date departureDate = tourFeign.selectDepartureDataBySpeId(tourDetail.getSpePriceId());
        Integer departureStatus = tourFeign.selectDepartureStatusByVerificationId(verificationId);
        departureDate.setHours(0);
        departureDate.setMinutes(0);
        departureDate.setSeconds(0);

        if (Instant.now().toEpochMilli()<departureDate.toInstant().toEpochMilli()){
            return ObjectRestResponse.createFailedResultWithObj(400,"还未到发车时间",0);
        }
        departureDate.setHours(0);
        departureDate.setMinutes(0);
        departureDate.setSeconds(0);
        Instant seconddayInstant = departureDate.toInstant().plus(1, ChronoUnit.DAYS);
        if(Instant.now().toEpochMilli()>seconddayInstant.toEpochMilli()){
            return ObjectRestResponse.createFailedResultWithObj(400,"该票已无效",2);
        }

        if (departureStatus==1){
            return ObjectRestResponse.createFailedResultWithObj(400,"已经发车",1);
        }



        baseOrder=new BaseOrder();
        baseOrder.setId(orderId);
        baseOrder.setStatus(OrderStatusEnum.ORDER_FINISH.getCode());
        baseOrder.setVersion(version);
        baseOrder = baseOrderBiz.updateSelectiveByIdReT(baseOrder);
        tourDetail.setVerificationUser(userDTO.getId());
        tourDetail.setVerificationName(userDTO.getName());
        tourDetail.setVerificationTime(System.currentTimeMillis());
        tourDetail = tourDetailBiz.updateSelectiveByIdReT(tourDetail);
        tourFeign.updateTourGoodPersonNum(verificationId,"verification_person",total_number);
        baseOrderBiz.sendOrderMq(null,tourDetail,null, baseOrder, OrderMQDTO.ORDER_FINISH);
        //订单完成时，payway为 支付宝，则转支付
        orderAccountBiz.finishFreeze2PayAmount(baseOrder);
        return  ObjectRestResponse.succ(tourDetail.getVerificationId());
    }

    //确定上车
    public ObjectRestResponse finishByOrder(Integer verificationId){

        return  ObjectRestResponse.succ(tourFeign.updateTourGoodVerificationStatus(verificationId));
    }

    //核销列表
    public ObjectRestResponse getVerifications(TourGoodOrderFindVo tourGoodOrderFindVo){

        return  ObjectRestResponse.succ(tourFeign.findTourGoodOrders(tourGoodOrderFindVo));
    }

    public  boolean isPower(List<BranchCompany> list,Integer companyId){
        boolean falg=false;
        if(list.size()>0){
            for (BranchCompany company:list) {
                if(company.getId()==companyId){
                    falg=true;
                    break;
                }

            }
        }
        return  falg;
    }





}