package com.xxfc.platform.order.pojo.order.add;

import com.xxfc.platform.order.pojo.OrderAccompanyDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.DATE_TIME_LINE_FORMATTER;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.YMR_SLASH_FORMATTER;

@Data
public class AddRentVehicleDTO extends AddOrderCommonDTO{
//    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    //开始时间
    @ApiModelProperty(value = "开始时间")
    private Long startTime;

    //结束时间
    @ApiModelProperty(value = "结束时间")
    private Long endTime;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty(value = "预定目标日期(开始)", hidden = true)
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty(value = "预定目标日期(结束)", hidden = true)
    private String bookEndDate;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty(value = "预定目标时间(开始)", hidden = true)
    private String bookStartDateTime;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty(value = "预定目标时间(结束)", hidden = true)
    private String bookEndDateTime;

    //天数
    @ApiModelProperty(value = "天数")
    private Integer dayNum;

    //取车地点
    @ApiModelProperty(value = "取车地点")
    private String startAddr;

    //还车地点
    @Column(name = "end_addr")
    @ApiModelProperty(value = "还车地点")
    private String endAddr;

    //取车城市编号
    @ApiModelProperty(value = "取车城市编号")
    private Integer startCity;

    //还车城市编号
    @Column(name = "end_city")
    @ApiModelProperty(value = "还车城市编号")
    private Integer endCity;

    //取车城市名称
    @ApiModelProperty(value = "取车城市名称")
    private String startCityName;

    //还车城市名称
    @Column(name = "end_city_name")
    @ApiModelProperty(value = "还车城市名称")
    private String endCityName;

    //司机类型 1--公司司机；2--自己司机
    @ApiModelProperty(value = "司机类型 1--公司司机；2--自己司机")
    private Integer driverType;

    //自己司机ids
    @ApiModelProperty(value = "自己司机ids")
    private String myDriverIds;

    //出发公司Id
    @ApiModelProperty(value = "出发公司Id")
    private Integer startCompanyId;

    //结束公司Id
    @ApiModelProperty(value = "结束公司Id")
    private Integer endCompanyId;

    //车型id
    @ApiModelProperty(value = "车型id")
    private Integer modelId;

    //车型id
    @ApiModelProperty(value = "是否购买免赔")
    private Integer damageSafe;

    /**
     * 是否使用出租免费天数
     */
    @ApiModelProperty(value = "是否使用出租免费天数")
    private Integer rentFreeDay;

    /**
     * 优惠券*
     */
    @ApiModelProperty(value = "优惠卷卷号")
    private String tickerNos;

    @ApiModelProperty(value = "随车物品")
    private List<String> accompanyStrs;

    @ApiModelProperty(value = "随车物品", hidden = true)
    private List<OrderAccompanyDTO> accompanyItems;

    @ApiModelProperty(value = "车辆id")
    private String vehicleId;

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
        this.bookStartDate = YMR_SLASH_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneOffset.ofHours(8)));
        this.bookStartDateTime = DATE_TIME_LINE_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneOffset.ofHours(8)));
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
        this.bookEndDate = YMR_SLASH_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endTime), ZoneOffset.ofHours(8)));
        this.bookEndDateTime = DATE_TIME_LINE_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endTime), ZoneOffset.ofHours(8)));
    }

    public void setAccompanyStrs(List<String> accompanyStrs) {
        this.accompanyStrs = accompanyStrs;
        if(null != accompanyStrs) {
            this.accompanyItems = this.accompanyStrs.parallelStream().map(str -> {
                String[] strs = str.split(",");
                if(strs.length < 2) {
                    return null;
                }
                OrderAccompanyDTO item = new OrderAccompanyDTO();
                item.setId(Integer.valueOf(strs[0]));
                item.setNum(Integer.valueOf(strs[1]));
                return item;
            }).collect(Collectors.toList());
        }
    }
}
