package com.xxfc.platform.order.pojo.dto;

import cn.hutool.core.date.DateUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/25 14:53
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseOrderDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 订单类型 1：租车  2：旅游 3：会员
     */
    private Integer type;
    /**
     * 实际支付金额
     */
    private BigDecimal realAmount;
    /**
     * 公司id(租车的出发公司)
     */
    private Integer companyId;
    /**
     * 支付方式
     */
    private Integer payWay;
    /**
     * 支付终端
     */
    private Integer payOrigin;
    /**
     * 支付时间
     */
    private Long payTime;
    /**
     * 支付时间转化日期
     */
    private Date payDate;
    /**
     * 区域id
     */
    private Integer areaId;
    /**
     * 订单量
     */
    private Integer orderNum;


    public Date getPayDate() {
        return Objects.isNull(payTime) ? payDate : DateUtil.beginOfDay(new Date(payTime));
    }

    public Integer getOrderNum() {
        return Objects.isNull(orderNum) ? 1 : orderNum;
    }
}
