package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 门店收支明细
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "company_wallet_detail")
public class CompanyWalletDetail implements Serializable {
	private static final long serialVersionUID = 1L;


    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键ID")
    private Integer id;



	@Column(name = "cono")
	@ApiModelProperty(value = "订单号或提现号")
	private String cono;


	@Column(name = "itype")
	@ApiModelProperty(value = "收支分类")
	private Integer itype;


    @Column(name = "source")
	@ApiModelProperty(value = "收支类型：见枚举")
    private Integer source;
	

    @Column(name = "type")
	@ApiModelProperty(value = "类型：1-收入；2-支出")
    private Integer type;
	


    @Column(name = "amount")
	@ApiModelProperty(value = "收入/支出的金额(分)")
    private BigDecimal amount;




	@Column(name = "branch_id")
	@ApiModelProperty(value = "企业id")
	private Long branchId;



	@Column(name = "company_id")
	@ApiModelProperty(value = "门店id")
	private Integer companyId;


	

    @Column(name = "s_amount")
	@ApiModelProperty(value = "门店剩余金额")
    private BigDecimal sAmount;
	

	

    @Column(name = "crt_time")
	@ApiModelProperty(value = "操作时间", hidden = true )
    private Long crtTime;


	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除：0-正常;1-删除")
	private Integer isDel;


}
