package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 门店钱包
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-11 14:14:54
 */
@Data
@Table(name = "company_wallet")
public class CompanyWallet implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
     *  id
     */
    @Column(name = "id")
	@ApiModelProperty(value = "id")
    private Integer id;
	
	    /**
    *  用户ID
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("门店ID")
    private Integer companyId;

	/**
	 *  余额(分)
	 */
	@Column(name = "balance")
	@ApiModelProperty(value = "余额(元)")
	private BigDecimal balance;

	
	/**
     *  支付密码
     */
    @Column(name = "pay_password")
	@ApiModelProperty(value = "支付密码")
    private String payPassword;
	
    /**
     *  已提现金额
     */
    @Column(name = "withdrawals")
	@ApiModelProperty(value = "已提现金额")
    private BigDecimal withdrawals;
	
	    /**
     *  进账总额(分)
     */
    @Column(name = "total_amount")
	@ApiModelProperty(value = "进账总额(元)")
    private BigDecimal totalAmount;

	/**
	 *  今日收益
	 */
	@Column(name = "today_amount")
	@ApiModelProperty(value = "今日收益")
	private BigDecimal todayAmount;
	
	    /**
     *  未入账金额
     */
    @Column(name = "unbooked")
	@ApiModelProperty(value = "未入账金额")
    private BigDecimal unbooked;
	
	    /**
     *  是否冻结：0-正常，1-冻结
     */
    @Column(name = "is_frozen")
	@ApiModelProperty(value = "是否冻结：0-正常，1-冻结")
    private Integer isFrozen;
	
	    /**
     *  最后进账时间
     */
    @Column(name = "last_intime")
	@ApiModelProperty(value = "最后进账时间")
    private Long lastIntime;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  版本
     */
    @Column(name = "version")
	@ApiModelProperty(value = "版本")
    private Integer version;
	

}
