package com.xxfc.platform.campsite.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 店铺轮播表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-17 10:28:48
 */
@Data
@Table(name = "campsite_shop_carousel")
public class CampsiteShopCarousel implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键自增字段
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键自增字段")
    private Integer id;

    /**
     * 营地id
     */
    @Column(name = "shop_id")
    @ApiModelProperty(value = "营地id")
    private Integer shopId;

    /**
     * 访问链接
     */
    @Column(name = "url")
    @ApiModelProperty(value = "访问链接")
    private String url;

    /**
     * 轮播图片链接
     */
    @Column(name = "img_url")
    @ApiModelProperty(value = "轮播图片链接")
    private String imgUrl;

    /**
     * 图片名称
     */
    @Column(name = "name")
    @ApiModelProperty(value = "图片名称")
    private String name;

    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    @ApiModelProperty(value = "是否删除：0-正常；1-删除")
    private Integer isDel;


}
