package com.xxfc.platform.app.biz;


import com.ace.cache.annotation.CacheClear;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.app.entity.AppVersionMark;
import com.xxfc.platform.app.entity.dto.AppVersionMarkDTO;
import com.xxfc.platform.app.mapper.AppVersionMarkMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Slf4j
/**
 * @Author: zyh
 * @Date: 2020/1/10
 */
public class AppVersionMarkBiz extends BaseBiz<AppVersionMarkMapper, AppVersionMark> {
    private static final int RANDOM_TWO_LENGTH = 2;
    private static final int CHANGE_UPD_APP_MARK = 1;
    private static final int APP_MARK_IS_DEL = 1;
    private static final int CHANGE_DELETE_APP_MARK = 2;
    private static final int NO_RANDOM_REAPPEAR = 50;
    public static final int IS_DEL_IOS_OR_ANDROID = 1;
    public static final int SUCCESSFUL_OPERATION_CODE = 1;
    public static final int FAIL_OPERATION_CODE = 2;
    public static final String SUCCESSFUL_OPERATION = "操作成功";
    public static final String FAIL_OPERATION = "安卓/苹果不可删除";

    /**
     * @Description: 新增APP版本标识
     * @Param: AppVersionMarkDTO appVersionMarkDTO
     * @return:
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @CacheClear
    public Map<Integer, String> addAppVersionMark(AppVersionMarkDTO appVersionMarkDTO) {
        Map<Integer, String> statusMap = new HashedMap<>();
        if (StringUtils.isBlank(appVersionMarkDTO.getMarkName()) || StringUtils.isBlank(appVersionMarkDTO.getMarkRemark())
                || StringUtils.isBlank(appVersionMarkDTO.getSourceType()) || StringUtils.isBlank(appVersionMarkDTO.getMark())) {
            statusMap.put(FAIL_OPERATION_CODE, "参数不能为空");
            return statusMap;
        }
        AppVersionMark appVersionMark = new AppVersionMark();
        String markNoBlank = appVersionMarkDTO.getMark().replaceAll(" ", "");
        int count = mapper.queryIsMark(markNoBlank);
        if (count > 0) {
            statusMap.put(FAIL_OPERATION_CODE, "标识已存在,请重新输入");
            return statusMap;
        }
        try {
            Date date = new Date();
            //设置日期格式
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String nowTime = simpleDateFormat.format(date);
            Date crtTime = simpleDateFormat.parse(nowTime);
            appVersionMark.setCrtTime(crtTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        appVersionMark.setMark(markNoBlank);
        appVersionMark.setSourceType(appVersionMarkDTO.getSourceType());
        appVersionMark.setMarkName(appVersionMarkDTO.getMarkName());
        appVersionMark.setMarkRemark(appVersionMarkDTO.getMarkRemark());
        appVersionMark.setIsDel(0);
        // insertSelective(appVersionMark);
        mapper.insert(appVersionMark);
        statusMap.put(SUCCESSFUL_OPERATION_CODE, SUCCESSFUL_OPERATION);
        return statusMap;
    }


    /**
     * @Description: 随机产生，判断数据库是否已经存在
     * @return: 标识
     * @Author: zyh
     * @Date: 2020/1/10
     */
    public String getMark() {
        String mark = "";
        for (int i = 0; i < NO_RANDOM_REAPPEAR; i++) {
            mark = getCharAndNumr(RANDOM_TWO_LENGTH);
            int count = mapper.queryIsMark(mark);
            if (count == 0) {
                break;
            }
        }
        return mark;
    }

    /**
     * 生成随机数字和字母组合
     *
     * @param length
     * @return
     */
    public static String getCharAndNumr(int length) {
        StringBuffer valSb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            // 输出字母还是数字
            String charOrNum = Math.round(Math.random()) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                // 字符串  取得大写字母还是小写字母
                int choice = Math.round(Math.random()) % 2 == 0 ? 65 : 97;
                valSb.append((char) (choice + Math.round(Math.random() * 25)));
            } else if ("num".equalsIgnoreCase(charOrNum)) {
                // 数字
                valSb.append(String.valueOf(Math.round(Math.random() * 9)));
            }
        }
        return valSb.toString();
    }

    /**
     * @Description: app版本标识 更新以及删除
     * @Param: No such property: code for class: Script1
     * @return:
     * @Author: zyh
     * @Date: 2020/1/10
     */
    @CacheClear
    public Map<Integer, String> updAppVersionMark(AppVersionMarkDTO appVersionMarkDTO) {
        Map<Integer, String> statusMap = new HashedMap<>();
        AppVersionMark appVersionMark = new AppVersionMark();
        BeanUtils.copyProperties(appVersionMarkDTO, appVersionMark);
        if (appVersionMarkDTO.getChangeMark() == CHANGE_UPD_APP_MARK) {
            if (StringUtils.isNotEmpty(appVersionMarkDTO.getMark())) {
                String markNoBlank = appVersionMarkDTO.getMark().replaceAll(" ", "");
                int count = mapper.queryIsMark(markNoBlank);
                if (count >0) {
                    statusMap.put(FAIL_OPERATION_CODE, "标识已存在,请重新更改标识");
                    return statusMap;
                }
                appVersionMark.setMark(markNoBlank);
            }
            updateSelectiveById(appVersionMark);
        } else if (appVersionMarkDTO.getChangeMark() == CHANGE_DELETE_APP_MARK) {
            Integer count = mapper.findIosOrAndroidVersionAppMark(appVersionMarkDTO.getId());
            if (count.equals(IS_DEL_IOS_OR_ANDROID)) {
                statusMap.put(FAIL_OPERATION_CODE, FAIL_OPERATION);
                return statusMap;
            }
            appVersionMark.setIsDel(APP_MARK_IS_DEL);
            updateSelectiveById(appVersionMark);
        }
        statusMap.put(SUCCESSFUL_OPERATION_CODE, SUCCESSFUL_OPERATION);
        return statusMap;
    }

    /**
     * @Description: 查询页面展示
     * @Param:
     * @return: AppVersionMarkDTO  appVersionMarkDTO
     * @Author: zyh
     * @Date: 2020/1/10
     */
    public List<AppVersionMarkDTO> findVersionAppMark(String mark) {
        List list = mapper.findVersionAppMark(mark);
        return list;
    }

    /**
     * @Description: 会员页面查询注册来源 下拉框接口
     * @Param:
     * @return: list（mark名称）
     * @Author: zyh
     * @Date: 2020/1/13
     */
    public List<AppVersionMarkDTO> findListVersionAppMark() {
        List list = mapper.findListVersionAppMark();
        return list;
    }

}


