package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppStaffUserBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserDetailBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserLoginBiz;
import com.github.wxiaoqi.security.admin.entity.AppStaffUser;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("/staff")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"员工客户管理"})
public class AppStaffUserController extends BaseController<AppStaffUserBiz, AppStaffUser> {
    private final UserAuthConfig authConfig;
    private final HttpServletRequest request;
    private final PublicController publicController;
    private final Integer POSITION_ID=4;
    private final UserAuthUtil userAuthUtil;
    private final AppUserLoginBiz appUserLoginBiz;
    private final AppUserDetailBiz appUserDetailBiz;

    /**
     * 获取该用户所用的客户
     * @return
     * @throws Exception
     */
    @GetMapping("/getAll")
    public  ObjectRestResponse<List<AppStaffUser>> getAll() throws Exception {
        AppUserDTO userDTO = (AppUserDTO) publicController.userDetailByToken(authConfig.getToken(request)).getData();
        if (POSITION_ID.equals(userDTO.getPositionId())) {
            return ObjectRestResponse.succ(baseBiz.getAll(userDTO.getUserid(),userDTO.getUsername())) ;
        }
     return ObjectRestResponse.succ();
    }

    @Override
    @ApiOperation("添加")
    @PostMapping(value = "")
    public ObjectRestResponse<AppStaffUser> add(@RequestBody AppStaffUser appStaffUser)  {
        IJWTInfo infoFromToken = null;
        try {
            infoFromToken = userAuthUtil.getInfoFromToken(authConfig.getToken(request));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ObjectRestResponse.createDefaultFail();
        }
        Integer positionId = null;
        try {
            positionId = appUserDetailBiz.getUserInfoById(
                    appUserLoginBiz.getUserByUsername(appStaffUser.getPhone()).getId()
            ).getPositionId();
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (POSITION_ID.equals(positionId)) {
           return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"绑定错误");
        }
        appStaffUser.setSuId(Integer.valueOf(infoFromToken.getId()));
        if (baseBiz.select(appStaffUser)) {
            baseBiz.insertSelective(appStaffUser);
            return  ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"客户已存在");

    }

    @ApiOperation("查询一条")
    @GetMapping(value = "one")
    public ObjectRestResponse<AppStaffUser> findOne(AppStaffUser appStaffUser)  {
        AppStaffUser staffUser = baseBiz.findOne(appStaffUser);
        if (staffUser!=null) {
            return ObjectRestResponse.succ(staffUser);
        }
        return ObjectRestResponse.succ();
    }

    @ApiOperation("删除")
    @DeleteMapping(value = "delete/{id}")
    public ObjectRestResponse<AppStaffUser> delete(@PathVariable Integer id) throws Exception {
        IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(authConfig.getToken(request));
        String userid = infoFromToken.getId();
        AppStaffUser staffUser = new AppStaffUser();
        staffUser.setId(id);
        staffUser.setIsDel(1);
        baseBiz.update(staffUser,Integer.valueOf(userid));
        return ObjectRestResponse.succ();
    }

    @Override
    @ApiOperation("修改")
    @RequestMapping(value = "/{id}",method = RequestMethod.PUT)
    @ResponseBody
    public ObjectRestResponse update(@RequestBody AppStaffUser appStaffUser) throws Exception {
        IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(authConfig.getToken(request));
        Integer positionId = null;
        try {
            positionId = appUserDetailBiz.getUserInfoById(
                    appUserLoginBiz.getUserByUsername(appStaffUser.getPhone()).getId()
            ).getPositionId();
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (appStaffUser.getPhone().equals(infoFromToken.getUniqueName())||POSITION_ID.equals(positionId)) {
            return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"绑定错误");
        }
        appStaffUser.setSuId(Integer.valueOf(infoFromToken.getId()));
            baseBiz.updateSelectiveById(appStaffUser);
            return ObjectRestResponse.succ();
    }

}
