package com.github.wxiaoqi.security.admin.vo;

import com.github.wxiaoqi.security.admin.entity.Group;
import com.github.wxiaoqi.security.admin.entity.User;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Table;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/8 16:08
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BaseUserVo extends User {
    private String companyName;
    private String corporationName;

    private List<Group> groupList;
    private String groupStr;


    public  String getGroupStr(){
        if (groupList != null && groupList.size() > 0){
            groupStr= groupList.stream().map(Group::getName).collect(Collectors.joining(","));
        }
        return  groupStr;
    }
}
