package com.github.wxiaoqi.security.admin.feign.rest;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.DataInter;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

public interface UserRestInterface  {
    public UserFeign getUserFeign();



    default HttpServletRequest getRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    default AppUserDTO getAppUser(){
        return  getUserFeign().userDetailByToken(BaseContextHandler.getToken()).getData();
    }

    default void checkAppUser(){
        if(null == getAppUser()) {
            throw new BaseException(ResultCode.DB_OPERATION_FAIL_CODE);
        }
    }

    default UserDTO getAdminUserInfo() {
        if(getRequest().getHeader("Authorization") !=null) {
            return getUserFeign().userinfoByToken(getRequest().getHeader("Authorization")).getData();
        }else {
            return null;
        }
    }

    default UserDTO getAdminUserInfoV2(boolean flag) {
        if(getRequest().getHeader("Authorization") !=null) {
            return getUserFeign().userinfoByTokenV2(getRequest().getHeader("Authorization"),flag).getData();
        }else {
            return null;
        }
    }

    default void checkAdminUser(){
        if(null == getAdminUserInfo()) {
            throw new BaseException(ResultCode.NOTEXIST_CODE);
        }
    }

    default  void  setPowerData(DataInter dataInter,boolean flag){
        UserDTO userDTO = getAdminUserInfoV2(flag);
        if (userDTO == null) {
            return;
        }
        Integer dataAll=userDTO.getDataAll()== null ? 2 : userDTO.getDataAll();
        System.out.println("---dataAll==="+dataAll);
        if (dataAll == 2){
            List<Integer> dataCompany2List = userDTO.dataCompany2List();
            if (dataCompany2List != null && dataCompany2List.size() > 0){
                dataInter.setDataCompanyIds(dataCompany2List);
            }else {
                List<Integer> dataCorporation2List = userDTO.dataCorporation2List();
                if (dataCorporation2List != null && dataCorporation2List.size() > 0){
                    if (flag){
                        dataInter.setDataCorporationIds(dataCorporation2List);
                    }else {
                        dataInter.setDataCompanyIds(dataCompany2List);
                    }

                }else {
                    List<Integer> ids=new ArrayList<>();
                    ids.add(0);
                    dataInter.setDataCompanyIds(ids);
                }
            }
        }
    }

}
