package com.github.wxiaoqi.security.common.config.rabbit;

import java.util.HashSet;
import java.util.Set;

public class RabbitConstant {
    public static Set<String> exchangeTopicSet;
    public static Set<String> exchangeDirectSet;
    public static String TOPIC_EXC = "_topic_exchange";
    public static String DIRECT_EXC = "_direct_exchange";

    public static final String ADMIN = "admin";
    public static final String ADMIN_TOPIC = ADMIN+ TOPIC_EXC;
    public static final String ORDER = "order";
    public static final String ORDER_TOPIC = ORDER+ TOPIC_EXC;
    public static final String INTEGRAL = "integral";
    public static final String INTEGRAL_TOPIC = INTEGRAL + TOPIC_EXC;
    public static final String ACTIVITY_PRIZE="activity:prize";
    public static final String ACTIVITY_PRIZE_TOPIC=ACTIVITY_PRIZE+TOPIC_EXC;
    public static final String VEHICLE = "vehicle";
    public static final String VEHICLE_TOPIC = VEHICLE+ TOPIC_EXC;

    /**************************key*********************************/
    //用户
    public static final String KEY_APPUSER_REGISTER = "appUser.register";
    public static final String KEY_APPUSER_AUTH = "appUser.auth";

    //积分
    public static final String INTEGRAL_ROUTING_KEY = "integral_routing_key";

    //订单
    public static final String KEY_ORDER_PAY = "order.pay";
    public static final String KEY_ORDER_FINLISH = "order.finlish";
    public static final String KEY_ORDER_CANCEL = "order.cancel";
    public static final String KEY_ORDER_PART_DEPOSIT = "order.partDeposit";

    //钱包
    public static final String KEY_WALLET_ADD = "wallet.add";

    public static final String KEY_WALLET_WITH_DRAW="wallet.withdraw";

    //抽奖
    public static final String KEY_ACTIVITY_PRIZE_RECORD="prize:record";


    //企业信息
    public static final String KEY_CORPORATION_UPD="corporation:upd";


    //门店信息
    public static final String KEY_COMPANY_UPD="company:upd";

    static {
        exchangeTopicSet = new HashSet<String>() {{
           add(ADMIN_TOPIC);
           add(ORDER_TOPIC);
           add(INTEGRAL_TOPIC);
           add(ACTIVITY_PRIZE_TOPIC);
            add(VEHICLE_TOPIC);
        }};
    }
}
