package com.xxfc.platform.im.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.biz.ImQuestionBiz;
import com.xxfc.platform.im.dto.QuestionParamDto;
import com.xxfc.platform.im.entity.ImQuestion;
import com.xxfc.platform.im.vo.QuestionListVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "imQuestion")
@Api(value = "问答信息模块")
public class ImQuestionController {

    @Autowired
    ImQuestionBiz imQuestionBiz;

    @GetMapping(value = "/list")
    @ApiOperation(value = "获取问答列表信息")
    public ObjectRestResponse<List<QuestionListVo>> getList(QuestionParamDto questionParamDto) {
        return imQuestionBiz.getList(questionParamDto);
    }
    @GetMapping(value = "/one")
    @ApiOperation(value = "获取问答列表信息")
    public ObjectRestResponse<ImQuestion> one(Integer id) {
        return imQuestionBiz.one(id);
    }
    @PostMapping(value = "/add")
    @ApiOperation(value = "添加问答信息")
    public ObjectRestResponse add(@RequestBody ImQuestion imQuestion) {
        return imQuestionBiz.add(imQuestion);
    }

    @PostMapping(value = "/delete")
    @ApiOperation(value = "删除问答信息")
    public ObjectRestResponse delete(Long id) {
        return imQuestionBiz.delete(id);
    }

    @GetMapping(value = "/bg/app/unauth/delete")
    @ApiOperation(value = "删除问答信息")
    public ObjectRestResponse deleteById(Long id) {
        return imQuestionBiz.deleteById(id);
    }

    @PostMapping(value = "/bg/app/unauth/update")
    @ApiOperation(value = "修改问答信息")
    public ObjectRestResponse update(@RequestBody ImQuestion imQuestion) {
        return imQuestionBiz.update(imQuestion);
    }

    @PostMapping(value = "/bg/app/unauth/add")
    @ApiOperation(value = "添加问答信息")
    public ObjectRestResponse bgAdd(@RequestBody ImQuestion imQuestion) {
        return imQuestionBiz.bgAdd(imQuestion);
    }

}
