package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.AppShareholderDetailBiz;
import com.github.wxiaoqi.security.admin.dto.AppShareholderDetailFindDTO;
import com.github.wxiaoqi.security.admin.vo.AppShareholderDetailVo;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.auth.common.util.jwt.IJWTInfo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.util.excel.ExcelImport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/admin/appShareholder")
@Api("后台*会员管理")
public class AppShareholderDetailController {
    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @Autowired
    private AppShareholderDetailBiz appShareholderDetailBiz;

    @ApiOperation("批量导入股东")
    @PostMapping("/appShareholder/export")
    public ObjectRestResponse importAppShareholder(@RequestPart("file") MultipartFile appShareholderExcel, HttpServletRequest request) {
        try {
            IJWTInfo infoFromToken = userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request));
            List<String[]> appShareholderData = ExcelImport.getExcelData(appShareholderExcel);
            if (appShareholderData.size() < 1) {
                return ObjectRestResponse.createFailedResult(1001, "导入不能没数据！！！");
            }
            appShareholderData.remove(0);
            try {
                int effectSize = appShareholderDetailBiz.importShareholder(appShareholderData, Integer.valueOf(infoFromToken.getId()), infoFromToken.getUniqueName());
                return ObjectRestResponse.succ(effectSize);
            } catch (BaseException ex) {
                return ObjectRestResponse.createDefaultFail();
            }
        } catch (Exception e) {
            throw new BaseException(e);
        }
    }

    /**
     * 查询
     *
     * @param appShareholderDetailFindDTO
     * @return
     */
    @PostMapping("/page")
    public ObjectRestResponse<PageDataVO<AppShareholderDetailVo>> findWithPage(@RequestBody AppShareholderDetailFindDTO appShareholderDetailFindDTO) {
        PageDataVO<AppShareholderDetailVo> dataVO = appShareholderDetailBiz.findWithPage(appShareholderDetailFindDTO);
        return ObjectRestResponse.succ(dataVO);
    }


}
