package com.xxfc.platform.activity.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.activity.entity.IntegralUserStatus;
import com.xxfc.platform.activity.mapper.IntegralUserStatusMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.TimeZone;

@Service
@Transactional
public class IntegralUserStatusBiz extends BaseBiz<IntegralUserStatusMapper, IntegralUserStatus> {

    public ObjectRestResponse save(IntegralUserStatus integralUserStatus) {
        if(integralUserStatus != null) {
            IntegralUserStatus oldValue = mapper.selectByUserAndCode(integralUserStatus);
            if(oldValue != null) {
                BeanUtil.copyProperties(integralUserStatus, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
                updateSelectiveById(oldValue);
            }
            insertSelective(integralUserStatus);
        }
        return ObjectRestResponse.succ();
    }

    public IntegralUserStatus selectByUserAndCode(String code, Integer userId) {
        if(!StringUtils.isAllBlank(code, userId + "")) {
            long current = System.currentTimeMillis();
            long startTime = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
            IntegralUserStatus integralUserStatus = new IntegralUserStatus();
            integralUserStatus.setIntegralRuleCode(code);
            integralUserStatus.setUserId(userId);
            integralUserStatus.setStartTime(startTime);
            integralUserStatus.setEndTime(startTime  + 24 * 60 * 60 * 1000 - 1);
            return mapper.selectByUserAndCode(integralUserStatus);
        }
        return null;
    }

}
