package com.xxfc.platform.universal.feign;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.dto.SmsTemplateDTO;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.entity.IdInformation;
import com.xxfc.platform.universal.vo.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-universal", contextId = "universal-base")
public interface ThirdFeign {
    @RequestMapping(value = "/sms/app/unauth/send", method = RequestMethod.GET)
    public JSONObject send(@RequestParam(value = "phone") String phone);
    @RequestMapping(value = "/sms/app/unauth/sendCode", method = RequestMethod.GET)
    //发送短信模板消息
    public JSONObject sendCode(@RequestParam("phone") String phone, @RequestParam("code")String code, @RequestParam("templateCode")String templateCode );
    //云通讯短信机
    @RequestMapping(value = "/sms/app/unauth/sendTemplate", method = RequestMethod.POST)
    public ObjectRestResponse sendTemplate(@RequestBody SmsTemplateDTO smsTemplateDTO);
    @RequestMapping(value = "/file/app/unauth/uploadFiles", method = RequestMethod.POST)
    public JSONObject uploadFiles(@RequestParam(value = "files") MultipartFile[] files);
    @RequestMapping(value = "/pay/app/wx", method = RequestMethod.POST)
    public JSONObject wx(@RequestBody OrderPayVo orderPayVo);
    @RequestMapping(value = "/refund/app/pay/refund", method = RequestMethod.POST)
    public ObjectRestResponse<String> refund(@RequestBody OrderRefundVo orderRefundVo);

    /**
     * 获取支持的城市
     * @return
     */
    @GetMapping("/city")
    ObjectRestResponse getCityInfo();

    /**
     * 违章车辆查询
     * @return
     */
    @PostMapping("/trafficViolations")
    ObjectRestResponse queryTrafficViolations(@RequestBody TrafficViolations trafficViolations) ;

    /**
     * 车辆类型查询
     * @return
     */
    @GetMapping("/LicensePlateType")
    ObjectRestResponse getLicensePlateType();

    /*****************************************  数据字典 ********************************************/


    @RequestMapping(value = "/dictionary/getParents", method = RequestMethod.GET)
    public ObjectRestResponse<List<Dictionary>> dictionaryGetParent(@RequestParam(value = "type") String type);

    @RequestMapping(value = "/dictionary/get", method = RequestMethod.GET)
    public ObjectRestResponse<List<Dictionary>> dictionaryGet(@RequestParam(value = "dictionary") Map<String, Object> dictionary);

    @RequestMapping(value = "/dictionary/getAll4Map", method = RequestMethod.GET)
    public ObjectRestResponse<Map<String, Dictionary>> dictionaryGetAll4Map();

/*    @RequestMapping(value = "/dictionary/getAll4Map", method = RequestMethod.GET)
    public ObjectRestResponse<Map<String, Dictionary>> getDictionaryUseType();*/

     @PostMapping("/dictionary/type_code")
    public  Dictionary findDictionaryByTypeAndCode(@RequestParam(value = "type") String type,@RequestParam(value = "code") String code);

    @GetMapping(value = "/certif/app/unauth/selectByUser")
    public IdInformation getOneByUserId(@RequestParam(value = "userId")Integer userId);

    /*****************************************  违章 ********************************************/
    @GetMapping("/3p/tv/getRentViolation")
    public ObjectRestResponse<List<ViolationVO>> getRentViolation(@RequestParam(value = "rentViolationDTO") Map<String, Object> rentViolationDTO);


    /*************************************支付***************************************/
    @PostMapping("/pay/app/unauth/transfer_account")
    ObjectRestResponse<String> transferAccount(@RequestBody FundPayVo fundPayVo);


    @GetMapping("/info/app/unauth/getAliPayUserInfo")
    public ObjectRestResponse<String> getAliPayUserInfo(@RequestParam(value = "code")String code);
}
