package com.xxfc.platform.order.pojo.account;

import com.xxfc.platform.order.contant.enumerate.DeductionTypeEnum;
import lombok.Data;
import org.assertj.core.util.Lists;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderAccountDetail {
    /**
     * 实际返回订单款 账单的的orderAmount 对应的是 订单的商品金额
     */
    BigDecimal orderAmount = BigDecimal.ZERO;
    /**
     * 实际返回押金款
     */
    BigDecimal depositAmount = BigDecimal.ZERO;
    /**
     * 原来要返回的订单款 账单的的orderAmount 对应的是 订单的商品金额
     */
    BigDecimal originOrderAmount = BigDecimal.ZERO;
    /**
     * 原来要返回的押金款
     */
    BigDecimal originDepositAmount = BigDecimal.ZERO;

    /**
     * 扣款列表
     */
    List<OrderAccountDeduction> deductions = Lists.newArrayList();

    public BigDecimal realTotalDeduct() {
        return originDepositAmount.add(originOrderAmount).subtract(orderAmount).subtract(depositAmount);
    }

    public void changeCancelViolate(BigDecimal coverAmount) {
        if(null != coverAmount) {
            for(OrderAccountDeduction deduction : deductions) {
                if(DeductionTypeEnum.VIOLATE_CANCEL.getCode().equals(deduction)) {
                    //修改取消违约金
                        //获取差值
                    BigDecimal diff = coverAmount.subtract(deduction.getAmount());
                        //修改归还押金金额
                    setDepositAmount(getDepositAmount().subtract(diff));
                    deduction.setAmount(coverAmount);
                }
            }
        }
    }
}
