package com.github.wxiaoqi.security.admin.feign;

import com.github.wxiaoqi.security.admin.bo.UserBo;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.entity.BaseUserMember;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberLevel;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.admin.vo.ImiVo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "ace-admin")
public interface UserFeign {

    public static final int MEMBER_DAYS_LOCK = 1;
    public static final int MEMBER_DAYS_CONFIRM = 2;
    public static final int MEMBER_DAYS_WITHDRAW = 3;

    //后台用户
    @RequestMapping(value = "/public/userinfo-by-token")
    public ObjectRestResponse<UserDTO> userinfoByToken(@RequestParam("token") String token);

    @RequestMapping(value = "/public/userinfo-by-uid")
    public ObjectRestResponse<UserDTO> userinfoByUid(@RequestParam("uid") Integer uid);



    /**
     * token获取用户信息
     * @param token
     * @return
     */
    @RequestMapping(value = "/public/app/userinfo-by-token")
    public ObjectRestResponse<AppUserDTO> userDetailByToken(@RequestParam("token") String token);
    /**
     * id获取用户信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/public/app/userinfo-by-id")
    public ObjectRestResponse<AppUserDTO> userDetailById(@RequestParam("id") Integer id);


    @GetMapping("/app/user/app/unauth/getUserIdByUsername")
    public List<Integer> getUserIdByUsername(@RequestParam(value="keywords")String keywords);

    /**
     *status:0-判断是否认证过,1-认证成功后修改用户认证状态
     *userId:用户登录时的id,必须
     *idNumber:证件号,修改认证状态是必须有
     */
    @RequestMapping(value = "/api/app/user/authentication", method = RequestMethod.POST)
    public ObjectRestResponse authentication( @RequestParam(value="userId")Integer  userId,
                                              @RequestParam(value="name")String  name,
                                              @RequestParam(value="idNumber")String idNumber,
                                              @RequestParam(value="status")Integer  status);

    /**
     * 获取会员等级列表
     * @return
     */
    @RequestMapping(value = "/member/app/unauth/levels", method = RequestMethod.GET)
    public List<BaseUserMemberLevel> levels();

    /**
     * 获取单个会员等级
     * @return
     */
    @RequestMapping(value = "/member/app/unauth/level/{type}", method = RequestMethod.GET)
    public BaseUserMemberLevel level(@PathVariable(value = "type") Integer type);

    /**
     * 批量获取用户基本信息
     * @param ids
     * @return
     */
    @RequestMapping(value = "/public/getByUserIds", method = RequestMethod.GET)
    public ObjectRestResponse<List<AppUserVo>> getByUserIds(@RequestParam("ids")List<Integer> ids);

    /**
     * 购买会员
     * @param userMemberDTO
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/member/user/buyMember", method = RequestMethod.POST)
    public ObjectRestResponse buyMember(@RequestBody UserMemberDTO userMemberDTO);

    /**
     * 订单更改会员
     * @param userId
     * @param days
     * @param type 1-用户锁定下单；2-购买下单;3-取消订单
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/member/user/memberDays", method = RequestMethod.POST)
    public int memberDays(
            @RequestParam(value = "userId",defaultValue = "0")Integer userId,
            @RequestParam(value = "days",defaultValue = "0")Integer days,
            @RequestParam(value = "type",defaultValue = "1")Integer type
    );

    @GetMapping("/member/entityList")
    public ObjectRestResponse<List<BaseUserMemberLevel>> memberEntityList(@RequestParam("entity") Map<String, Object> entity);

    @GetMapping("/app/user/one")
    public AppUserLogin one(@RequestParam(value = "username")String username);

    @GetMapping("/app/user/getOne")
    public List<AppUserLogin> getOne(@RequestParam(value = "username")String username,@RequestParam(value = "realName")String realName);

    @GetMapping("/api/app/imi/{imiId}")
    ImiVo findUserInfoByImiId(@PathVariable(value = "imiId") Integer imiId);

    @GetMapping("/app/user/findusersByIds")
    Map<Integer,AppUserLogin> findAppUsersByUserIds(@RequestParam(value = "userIds") List<Integer> userIds);

    @GetMapping("/app/user/finduserIdsByphones")
    Map<String, Integer> findAppusersByUserNames(@RequestParam(value = "phones") List<String> phones);

    @GetMapping("/member/user")
    BaseUserMember findBaseUserMemberByUserId(@RequestParam(value = "userId") Integer userId);


    @GetMapping("/wallet/withdraw_do")
    public ObjectRestResponse<Void> withDrawprocess(@RequestParam(value = "orderNo") String orderNo,
                                                    @RequestParam(value = "cono",required = false) String cono,
                                                    @RequestParam(value = "reason",required = false) String reason,
                                                    @RequestParam(value = "isSuccess") Boolean isSuccess);


    @GetMapping(value = "/app/user/users")
    List<Integer> findAppUserIds(@RequestParam(value = "phone",required = false) String phone,
                                 @RequestParam(value = "leaderPhone",required = false) String leaderPhone,
                                 @RequestParam(value = "name",required = false) String name);

    @PostMapping(value = "/app/user/users/info")
    List<UserBo> findUserDetailByUserBo(@RequestBody(required = false) List<UserBo> userBos);

}
