package com.github.wxiaoqi.security.common.msg.auth;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class PageResult<M> {
    /** 页码 */
    private Integer page;
    /** 每页结果数 */
    private Integer pageSize;
    /** 总页数 */
    private Integer totalPage;
    /** 总数 */
    private Integer total;

    private List<M> list=new ArrayList<>();

    private PageResult(){

    }

    private PageResult(int page, int pageSize, int totalPage, int total, List<M> list) {
        this.page = page;
        this.pageSize = pageSize;
        this.totalPage = totalPage;
        this.total = total;
        this.list = list;
    }

    public static PageResult  nowPageResult(Integer page, Integer limit, List totalList) {
        page=page!=null?page:1;
        limit=limit!=null?limit:10;
        //总条数
        Integer total=0;
        //总页数
        Integer totalPage=0;
        //当前页面数据条数
        Integer pageSize=0;
        //当前页面数据集合
        List list = new ArrayList();
        if (totalList!=null&&totalList.size()!=0){
            total= totalList.size();
            totalPage = (total / limit) + 1;
            //每页的起始索引
            Integer pageNo = (page - 1) * limit;

            if (pageNo + limit > total) {
                list = totalList.subList(pageNo, total);
            } else {
                list = totalList.subList(pageNo, pageNo + limit);
            }
            pageSize=list.size();
        }
        return new PageResult(page,pageSize,totalPage,total,list);
    }
}
