package com.xxfc.platform.vehicle.biz;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageHelper;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.google.common.collect.Lists;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.mapper.VehicleMapper;
import com.xxfc.platform.vehicle.pojo.ResultVehicleVo;
import com.xxfc.platform.vehicle.pojo.VehicleExcelVo;
import com.xxfc.platform.vehicle.pojo.VehiclePageQueryVo;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class VehicleInformationDownloadBiz extends BaseBiz<VehicleMapper, Vehicle> {

    @Autowired
    private VehicleBiz vehicleBiz;




    public List<ResultVehicleVo> getByPageNotAllData(VehiclePageQueryVo vehiclePageQueryVo, List<Integer> companyList) throws Exception {
        Map<String, Object> params = PropertyUtils.describe(vehiclePageQueryVo);
        //处理预定日期相关参数
        vehicleBiz.adjustBookedInfoParam(params, vehiclePageQueryVo);
        if (companyList != null && companyList.size() > 0) {
            params.put("companyList", companyList);
        } else {
            params.put("companyList", Arrays.asList(-1));
        }

        return  mapper.getByPageNotAllData(params);
    }

    public List<ResultVehicleVo> getByPage(VehiclePageQueryVo vehiclePageQueryVo) throws Exception  {

        Map<String, Object> params = PropertyUtils.describe(vehiclePageQueryVo);
        //处理预定日期相关参数
        vehicleBiz.adjustBookedInfoParam(params, vehiclePageQueryVo);
        params.get("yearMonthAndParam");
        if (vehiclePageQueryVo.getModelId() == null) {
            params.remove("modelId");
        }
        return  mapper.getByPage(params);
    }

    public List<ResultVehicleVo> getResultVehicleVoList(String vehiclePageQueryVoJson, UserDTO userDTO) {
        VehiclePageQueryVo vehiclePageQueryVo = new VehiclePageQueryVo();
        try {
            if (StringUtils.isNotBlank(vehiclePageQueryVoJson)){
                vehiclePageQueryVo = JSON.parseObject(vehiclePageQueryVoJson, VehiclePageQueryVo.class);
            }

                if (userDTO.getDataAll() == 2) {
                    List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                 return  getByPageNotAllData(vehiclePageQueryVo, companyList);
                }

          return   getByPage(vehiclePageQueryVo);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList();
    }


    public List<VehicleExcelVo> getList(String vehiclePageQueryVoJson, UserDTO userDTO) throws Exception  {
        List<ResultVehicleVo> resultVehicleVoList = getResultVehicleVoList(vehiclePageQueryVoJson, userDTO);
        ArrayList<VehicleExcelVo> arrayList = Lists.newArrayList();
        for (ResultVehicleVo resultVehicleVo : resultVehicleVoList) {
            VehicleExcelVo vehicleExcelVo = new VehicleExcelVo();
            BeanUtilsBean.getInstance().copyProperties(vehicleExcelVo,resultVehicleVo);
            arrayList.add(vehicleExcelVo);
        }
        return arrayList;

    }
}
