package com.xxfc.platform.order.biz;

import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.bo.LargeScreenDisplayConstantDataBo;
import com.xxfc.platform.order.entity.OrderProfileDisplay;
import com.xxfc.platform.order.mapper.OrderProfileDisplayMapper;
import com.xxfc.platform.order.pojo.vo.LargeScreenDisplayDataVo;
import com.xxfc.platform.order.pojo.vo.OrderProfileDispayVo;
import com.xxfc.platform.order.pojo.vo.OrderReceivedStatisticsBaseVo;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/12/24 17:06
 */
@Transactional(rollbackFor = Exception.class)
@Service
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class OrderProfileDisplayBiz extends BaseBiz<OrderProfileDisplayMapper, OrderProfileDisplay> {
    /**
     * 字典查询type
     */
    @Value("large.screen.type:LARGE_SCREEN_DISPLAY")
    private String largeScreenType;
    /**
     * 字典查询code
     */
    @Value("large.screen.code:LARGE_SCREEN_DISPLAY_CONSTANT")
    private String largeScreenCode;

    private final ThirdFeign thirdFeign;
    private final OrderReceivedStatisticsBiz orderReceivedStatisticsBiz;
    private final VehicleFeign vehicleFeign;

    /**
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @return
     */
    public LargeScreenDisplayDataVo findLargeScreenDisplayDataByDate(Date startDate, Date endDate) {
        LargeScreenDisplayDataVo largeScreenDisplayDataVo = new LargeScreenDisplayDataVo();
        //创建订单常量数据对象
        LargeScreenDisplayConstantDataBo largeScreenDisplayConstantDataBo = new LargeScreenDisplayConstantDataBo();
        //创建订单数据统计对象
        OrderProfileDispayVo orderProfileDispayVo = new OrderProfileDispayVo();

        //1.查询基础常量数据
        Dictionary largeScreenConstantDictionary = thirdFeign.findDictionaryByTypeAndCode(largeScreenType, largeScreenCode);
        if (Objects.nonNull(largeScreenConstantDictionary) && StringUtils.hasText(largeScreenConstantDictionary.getDetail())){
            largeScreenDisplayConstantDataBo = JSON.parseObject(largeScreenConstantDictionary.getDetail(), LargeScreenDisplayConstantDataBo.class);
        }
        //2.1查询订单统计数据
        List<OrderReceivedStatisticsBaseVo> orderReceivedStatisticsBaseVos = orderReceivedStatisticsBiz.findOrderReceivedStatisticsByDate(startDate,endDate);
        //2.2查询固定编者数据

        //3.


        largeScreenDisplayDataVo.setLargeScreenDisplayConstantData(largeScreenDisplayConstantDataBo);
        largeScreenDisplayDataVo.setOrderProfileDispayData(orderProfileDispayVo);
        return largeScreenDisplayDataVo;
    }
}
