package com.xxfc.platform.order.pojo.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * @author libin
 * @version 1.0
 * @description 订单概况视图
 * @data 2019/12/24 17:41
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OrderProfileDispayVo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 累计订单金额
     */
    private BigDecimal orderAmount = BigDecimal.ZERO;
    /**
     * 累计订单量
     */
    private long orderNum;
    /**
     * 今日订单金额
     */
    private BigDecimal todayOrderAmount = BigDecimal.ZERO;
    /**
     * 今日订单量
     */
    private long todayOrderNum;
    /**
     * 十大运营中心的租车订单统计
     */
    private List<CenterOrderProfileDisplayVo> centerOrderProfileDisplays;
    /**
     * 某个时间段的订单统计
     */
    private List<OrderProfileVo> orderProfiles;
    /**
     * 订单支付方式|终端
     */
    private OrderPayProfileDispalyVo orderPayProfileDisplay;

    public List<CenterOrderProfileDisplayVo> getCenterOrderProfileDisplays() {
        return CollectionUtils.isEmpty(centerOrderProfileDisplays) ? Collections.EMPTY_LIST : centerOrderProfileDisplays;
    }

    public OrderPayProfileDispalyVo getOrderPayProfileDispal() {
        return Objects.isNull(orderPayProfileDisplay) ? new OrderPayProfileDispalyVo() : orderPayProfileDisplay;
    }

    public List<OrderProfileVo> getOrderProfiles() {
        return CollectionUtils.isEmpty(orderProfiles) ? Collections.EMPTY_LIST : orderProfiles;
    }
}
