package com.xxfc.platform.order.bo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author libin
 * @version 1.0
 * @description 大屏展示的基础数据
 * @data 2019/12/24 16:21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LargeScreenDisplayConstantDataBo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 公司数量
     */
    private int companyNum;
    /**
     * 营地数量
     */
    private int campsiteNum;
    /**
     * 旅游路线数量
     */
    private int tourNum;
    /**
     * 订单金额基础金额
     */
    @JsonIgnore
    private BigDecimal baseOrderAmount = BigDecimal.ZERO;
    /**
     * 订单基础单量
     */
    @JsonIgnore
    private int baseOrderNum;
}
