package com.xxfc.platform.vehicle.rest;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.google.common.collect.Maps;
import com.xxfc.platform.vehicle.biz.*;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.CustomIllegalParamException;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.BookType;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.constant.VehicleBookRecordStatus;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.entity.VehicleBookInfo;
import com.xxfc.platform.vehicle.entity.VehicleBookRecord;
import com.xxfc.platform.vehicle.entity.VehicleDispatchInfo;
import com.xxfc.platform.vehicle.pojo.*;
import com.xxfc.platform.vehicle.pojo.dto.VehicleDispatchInfoDto;
import com.xxfc.platform.vehicle.pojo.dto.VehiclePlanDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import static com.xxfc.platform.vehicle.constant.VehicleConstant.USER_APP;
import static com.xxfc.platform.vehicle.constant.VehicleConstant.USER_APP_NAME;

@RestController
@RequestMapping("dispatch")
@Slf4j
@IgnoreClientToken
@Api(value="用车调度申请controller",tags={"用车调度申请接口"})
public class VehicleDispatchController extends BaseController<VehicleDispatchInfoBiz> {


    @GetMapping("page")
    @ApiModelProperty("获取申请列表")
    public ObjectRestResponse page(@RequestBody VehicleDispatchInfoDto dispatchInfoDto, HttpServletRequest request){
        return baseBiz.getInfoList(dispatchInfoDto,request);
    }


    @PostMapping("edit")
    @ApiModelProperty("获取申请列表")
    public ObjectRestResponse edit(@RequestBody VehicleDispatchInfo dispatchInfo){
        return baseBiz.addDisspatchInfo(dispatchInfo);
    }








}
