package com.xxfc.platform.order.pojo;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 总业绩报表类
 *
 * @author Administrator
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TotalOrderRevenue {
    @ApiModelProperty(value = "总订单数")
    private Integer orderSum;
    @ApiModelProperty(value = "应收总额")
    private BigDecimal totalReceivables=BigDecimal.ZERO;
    @ApiModelProperty(value = "优惠金额")
    private BigDecimal discount=BigDecimal.ZERO;
    @ApiModelProperty(value = "实收金额")
    private BigDecimal actual=BigDecimal.ZERO;
    @ApiModelProperty(value = "数据明细")
    private  PageInfo<Achievement> achievements;

}
