package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.dto.AppUserLogRemarkDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserLogRemark;
import com.github.wxiaoqi.security.admin.mapper.AppUserLogRemarkMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@Transactional
@Service
@Slf4j
public class AppUserLogRemarkBiz extends BaseBiz<AppUserLogRemarkMapper, AppUserLogRemark> {

    /**
     * 房车助手下级用户新增
     *
     * @param appUserLogRemarkDTO
     * @return
     */
    public ObjectRestResponse addAppUserLogRemark(AppUserLogRemarkDTO appUserLogRemarkDTO) {
        if (appUserLogRemarkDTO == null || StringUtils.isBlank(appUserLogRemarkDTO.getRemark()) || appUserLogRemarkDTO.getLevelId() == null) {
            ObjectRestResponse.createFailedResult(ResultCode.NOTEXIST_CODE, "参数不能为空");
        }
        AppUserLogRemark appUserLogRemark = new AppUserLogRemark();
        BeanUtils.copyProperties(appUserLogRemarkDTO, appUserLogRemark);
        insertSelective(appUserLogRemark);
        return ObjectRestResponse.succ();
    }

    /**
     * 房车助手下级用户查询
     */

    public List<AppUserLogRemark> findAppUserLogRemark(Integer levelId) {

        Example example = new Example(AppUserLogRemark.class);
        example.createCriteria().andEqualTo("levelId", levelId);
        example.orderBy("time").desc();
        List<AppUserLogRemark> list = selectByExample(example);
        return list;
    }


}
