package com.github.wxiaoqi.security.admin.biz;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.druid.sql.visitor.functions.If;
import com.github.wxiaoqi.security.admin.entity.AppStaffUser;
import com.github.wxiaoqi.security.admin.entity.AppStaffUserVo;
import com.github.wxiaoqi.security.admin.mapper.AppStaffUserMapper;
import com.github.wxiaoqi.security.admin.vo.AppUserVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.Date;
import java.util.List;

/**
 * @author Administrator
 */
@Service
@RequiredArgsConstructor(onConstructor_={@Autowired})
public class AppStaffUserBiz extends BaseBiz<AppStaffUserMapper, AppStaffUser> {
    private final  AppUserLoginBiz appUserLoginBiz;
    private final AppUserDetailBiz appUserDetailBiz;


    public List<AppStaffUser> getAll(Integer id) {
        Example example = new Example(AppStaffUser.class);
        example.createCriteria().andEqualTo("suId",id).andEqualTo("isDel",0);
        example.orderBy("crtTime").desc();
     return selectByExample(example);
    }

    @Override
    public int insertSelectiveRe(AppStaffUser appStaffUser) {
        appStaffUser.setCrtTime(new Date());
        return mapper.insertSelective(appStaffUser);
    }



    @Override
    public int updateSelectiveByIdRe(AppStaffUser appStaffUser) {
        appStaffUser.setUpdTime(new Date());
        return mapper.updateByPrimaryKeySelective(appStaffUser);
    }

    public AppStaffUser findOne(AppStaffUser appStaffUser) {
        Example example= new Example(AppStaffUser.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("isDel",0);
        if (appStaffUser.getId()!=null) {
            criteria.andEqualTo("id",appStaffUser.getId());
            return mapper.selectOneByExample(example);
        }

        if (appStaffUser.getPhone()!=null){
            criteria.andEqualTo("phone",appStaffUser.getPhone());
            List<AppStaffUser> appStaffUsers = mapper.selectByExample(example);
            if (CollectionUtil.isNotEmpty(appStaffUsers)) {
                AppStaffUser staffUser = appStaffUsers.get(0);
                AppStaffUserVo appStaffUserVo = new AppStaffUserVo();
                BeanUtils.copyProperties(staffUser,appStaffUserVo);
                Integer suId = staffUser.getSuId();
                AppUserVo userInfoById = appUserDetailBiz.getUserInfoById(suId);
                appStaffUserVo.setEmployeeName(userInfoById.getRealname());
                appStaffUserVo.setEmployeePhone(userInfoById.getUsername());
                return appStaffUserVo;
            }
        }

        return null;


    }

    public boolean select(AppStaffUser appStaffUser) {
        Example example=new Example(AppStaffUser.class);
        example.createCriteria().andEqualTo("uName",appStaffUser.getUName())
                .andEqualTo("phone",appStaffUser.getPhone())
                .andEqualTo("isDel",0);
        List<AppStaffUser> appStaffUsers = mapper.selectByExample(example);
        return CollectionUtil.isEmpty(appStaffUsers)?true:false;
    }

    public void update(AppStaffUser staffUser, Integer userid) {
        Example example = new Example(AppStaffUser.class);
        example.createCriteria().andEqualTo("id",staffUser.getId()).andEqualTo("suId",userid);
        mapper.updateByExampleSelective(staffUser,example);
    }
}
