package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.BaseUserMemberBiz;
import com.github.wxiaoqi.security.admin.dto.BaseUserMemberVO;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.entity.AppUserManage;
import com.github.wxiaoqi.security.admin.entity.BaseUserMember;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

/**
 * 用户会员
 * @author Administrator
 */
@RestController
@RequestMapping("baseUserMember")
@Api(tags = "后台获取和修改用户会员信息")
public class BaseUserMemberController extends BaseController<BaseUserMemberBiz, BaseUserMember> {

    @Autowired
    private UserFeign userFeign;

    @Autowired
    private UserAuthConfig userAuthConfig;
    /**
     * 获取用户会员
     * @param userId
     * @return
     */
    @ApiOperation(value = "根据用户id获取用户会员信息")
    @RequestMapping("/findOne/{userId}")
    public ObjectRestResponse<BaseUserMemberVO> findOneByUserId(@PathVariable Integer userId){
        return  ObjectRestResponse.succ(baseBiz.findOneByUserId(userId));
    }


    /**
     * 根据token获取用户会员信息
     * @return
     */

    @RequestMapping("/getUserMember")
    @ApiOperation(value = "根据token获取用户会员信息")
    public ObjectRestResponse<BaseUserMemberVO> findOneByToken(){
        try {
            AppUserDTO user = userFeign.userDetailByToken(userAuthConfig.getToken(request)).getData();
            return  ObjectRestResponse.succ(baseBiz.findOneByUserId(user.getUserid()));
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }



    }

//    /**
//     * 设置用户会员
//     * @param userMemberDTO
//     * @return
//     */
//    @PutMapping("/setUserMember")
//    public ObjectRestResponse UpdateUserMember(@RequestBody BaseUserMemberVO baseUserMemberVO)
//            throws Exception {
//        baseBiz.UpdateUserMember(baseUserMemberVO);
//        return ObjectRestResponse.succ();
//    }


    /**
     * 设置用户会员
     * @param userMemberDTO
     * @return
     */
    @PutMapping("/setUserMember")
    @ApiOperation(value = "修改用户会员信息")
    public ObjectRestResponse UpdateUserMember(@RequestBody UserMemberDTO userMemberDTO)
            throws Exception {

        if (userMemberDTO==null) {
            return ObjectRestResponse.createDefaultFail();
        }

        if (Objects.nonNull(userMemberDTO.getRentFreeDays())&&userMemberDTO.getRentFreeDays()<0){
            return ObjectRestResponse.createDefaultFail();
        }

        if (Objects.nonNull(userMemberDTO.getTotalNumber())&& userMemberDTO.getTotalNumber()<0){
            return ObjectRestResponse.createDefaultFail();
        }

        baseBiz.UpdateUserMember(userMemberDTO);
        return ObjectRestResponse.succ();
    }
}
