package com.xxfc.platform.activity.entity;

import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@Data
@Table(name = "active_product_specs")
public class ActivityProductSpecs {
    /**
     * 主键id
     */
    @Id
    private Long id;

    /**
     * 商品id
     */
    @Column(name = "goods_id")
    private Long goodsId;

    /**
     * 规格编号
     */
    private String code;

    /**
     * 规格图片
     */
    @Column(name = "specs_img")
    private String specsImg;

    /**
     * 排序
     */
    @Column(name = "specs_seq")
    private Integer specsSeq;

    /**
     * 规格价格
     */
    @Column(name = "goods_price")
    private BigDecimal goodsPrice;

    /**
     * 成本价
     */
    @Column(name = "specs_cost_price")
    private BigDecimal specsCostPrice;

    /**
     * 创建人ID
     */
    @Column(name = "crt_user")
    private Long crtUser;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Integer crtTime;

    /**
     * 更新人id
     */
    @Column(name = "upd_user")
    private Long updUser;

    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Integer updTime;

    /**
     * 是否删除：0-正常；1-删除
     */
    @Column(name = "is_del")
    private Boolean isDel;

    /**
     * 销量
     */
    private Integer sales;

    /**
     * 库存
     */
    private Integer stock;

    /**
     * 关联商品ID
     */
    @Column(name = "active_id")
    private Integer activeId;

    /**
     * 规格json
     */
    @Column(name = "goods_specs")
    private String goodsSpecs;

}