package com.xxfc.platform.vehicle.biz;


import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.VehicleCata;
import com.xxfc.platform.vehicle.mapper.VehicleCataMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Slf4j
public class VehicleCataBiz extends BaseBiz<VehicleCataMapper, VehicleCata> {


    //添加车辆配置
    @Transactional
    public RestResponse updateCataByModel(String ids, Integer modelId){
        String [] cataIds=ids.split(",");
        if(cataIds.length>0){
            List<Integer> array=new ArrayList<>();
            List<VehicleCata> all=new ArrayList<>();
            for (String str:cataIds) {
                Integer cataId=Integer.parseInt(str);
                VehicleCata vehicleCata=mapper.getOne(modelId,cataId);
                array.add(cataId);
                if(vehicleCata==null){
                    vehicleCata=new VehicleCata();
                    vehicleCata.setCataId(cataId);
                    vehicleCata.setVehicleModelId(modelId);
                    vehicleCata.setCrtTime(System.currentTimeMillis());
                    vehicleCata.setUpdTime(System.currentTimeMillis());
                    all.add(vehicleCata);
                   continue;
                }
            }

            if(array.size()>0){
                mapper.delList(array,modelId);
            }

            if(all.size()>0){
                mapper.addCataList(all);
            }

        }
        return RestResponse.suc();

    }


    public void inserts(ArrayList<com.xxfc.platform.vehicle.entity.VehicleCata> vcs) {
        mapper.addCataList(vcs);
    }


    public void updateIsdalByVehicleModelId(VehicleCata vehicleCata){
        mapper.updateIsdalByVehicleModelId( vehicleCata);
    }

    public void updateIsdalByVehicleCataId(VehicleCata vehicleCata) {
        mapper.updateIsdalByVehicleCataId(vehicleCata);
    }
}
