package com.xxfc.platform.vehicle.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Data
@Table(name = "branch_company")
public class BranchCompany {
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;

    /**
     * 分公司名称
     */
    @ApiModelProperty("分公司名称")
    private String name;

    /**
     * 分支机构类型
     */
    @Column(name = "branch_type")
    @ApiModelProperty("分支机构类型")
    private Integer branchType;

    /**
     * 分支机构所属机构
     */
    @Column(name = "subordinate_branch")
    @ApiModelProperty("分支机构所属机构")
    private Integer subordinateBranch;


    /**
     * 地址-省/直辖市(编码)
     */
    @Column(name = "addr_province")
    @ApiModelProperty("地址-省/直辖市(编码)")
    private Integer addrProvince;

    /**
     * 地址-市(编码)
     */
    @Column(name = "addr_city")
    @ApiModelProperty("地址-市(编码)")
    private Integer addrCity;

    /**
     * 地址-镇/县（编码）
     */
    @Column(name = "addr_town")
    @ApiModelProperty("地址-镇/县（编码）")
    private Integer addrTown;

    /**
     * 详细地址
     */
    @Column(name = "addr_detail")
    @ApiModelProperty("详细地址")
    private String addrDetail;

    private Date createTime;

    private Date updateTime;

    /**
     * 负责人
     */
    @ApiModelProperty("负责人")
    private String leader;

    /**
     * 负责人联系方式
     */
    @ApiModelProperty("负责人联系方式")
    private String leaderContactInfo;
    /**
     * 分公司状态
     */
    @ApiModelProperty("分公司状态")
    private Integer status;

    /**
     *公司地址-纬度
     */
    @ApiModelProperty("公司地址-纬度")
    private BigDecimal latitude;

    /**
     * 公司地址-经度
     */
    @ApiModelProperty("公司地址-经度")
    private BigDecimal longitude;

    private String companyPic;

    private Integer zoneId;

    private String phone;
}