package com.xxfc.platform.universal.biz;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.entity.OrderPay;
import com.xxfc.platform.universal.entity.OrderRefund;
import com.xxfc.platform.universal.mapper.OrderRefundMapper;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import com.xxfc.platform.universal.weixin.api.WxPayRefundUtils;
import com.xxfc.platform.universal.weixin.util.Snowflake;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;
import java.util.List;

/**
 * 订单支付退款表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Service
@Slf4j
public class OrderRefundBiz extends BaseBiz<OrderRefundMapper,OrderRefund> {

    @Autowired
    private  OrderPayBiz payBiz;
    @Value("${universal.cert}")
    private String APICLIENT_CERT ;

    //申请退款
    public JSONObject refund(OrderRefundVo orderRefundVo)throws Exception{
        if(orderRefundVo==null){
            log.error("-----参数为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        String order_no=orderRefundVo.getOrderNo();
        String appid= SystemConfig.APP_ID;
        String mchId=SystemConfig.APP_PARTNER;
        String partnerKey=SystemConfig.APP_PARTNER_KEY;
        Integer payAmount=orderRefundVo.getAmount();
        Integer refundAmount=orderRefundVo.getRefundAmount();

        //临时处理
        payAmount = payAmount/100000;
        if(payAmount <= 0) {
            payAmount = 1;
        }

        refundAmount = refundAmount/100000;
        if(refundAmount <= 0) {
            refundAmount = 1;
        }

        String refundDesc =StringUtils.isNotBlank(orderRefundVo.getRefundDesc())?orderRefundVo.getRefundDesc(): "审核通过，退款";
        String out_refund_no = Snowflake.build() + "";
        if(StringUtils.isBlank(order_no)||StringUtils.isBlank(appid)||StringUtils.isBlank(mchId)||StringUtils.isBlank(partnerKey)
        ||payAmount==null||payAmount==0||refundAmount==null||refundAmount==0){
            log.error("-----参数为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        Example example =new Example(OrderPay.class);
        example.createCriteria().andEqualTo("orderNo", order_no).andEqualTo("isDel",0).andEqualTo("status",1);
        List<OrderPay> list=payBiz.selectByExample(example);
        if(list.size()==0){
            log.error("---支付回调---trade_no====="+order_no+"----订单不存在或未支付");
            return JsonResultUtil.createFailedResult(ResultCode.FAILED_CODE, order_no+"订单不存在或未支付");
        }
        OrderPay orderPay=list.get(0);
        String out_trade_no=orderPay.getTradeNo();
        boolean flag=WxPayRefundUtils.refund(appid,mchId,partnerKey,out_trade_no,out_refund_no,payAmount+"",
                refundAmount+"",refundDesc,APICLIENT_CERT);
        if(flag){
            OrderRefund orderRefund= new OrderRefund();
            BeanUtils.copyProperties(orderRefund,orderRefundVo);
            if(StringUtils.isNotBlank(orderRefund.getRefundDesc())){
                orderRefund.setRefundDesc(refundDesc);
            }
            orderRefund.setUserId(orderPay.getUserId());
            orderRefund.setStatus(2);
            orderRefund.setFinishTime(System.currentTimeMillis());
            orderRefund.setRefundTradeNo(out_refund_no);
            orderRefund.setOutRefundNo(out_trade_no);
            orderRefund.setSerialNumber(orderPay.getSerialNumber());
            insertSelective(orderRefund);
            return JsonResultUtil.createSuccessResultWithObj(out_refund_no);
        }
        return JsonResultUtil.createDefaultFail();
    }
}