package com.xxfc.platform.order;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={OrderApplication.class})
public class RabbitmqTest {
    static final String exchangeName = "test_exchange";
    static final String queueName = "test_queue";
    static final String routingKey = "test_queue";

    @Test
    public void test() throws IOException, TimeoutException {
        //建立连接，创建通道
        ConnectionFactory fc = new ConnectionFactory();
        fc.setHost("10.5.52.3");
        fc.setPort(5672);
        fc.setUsername("guest");
        fc.setPassword("guest");
        fc.setVirtualHost("my_vhost");

        Connection conn = fc.newConnection();
        Channel channel = conn.createChannel();


        channel.exchangeDelete(exchangeName);  //删除路由

        Map<String, Object> map = new HashMap<>();
        map.put("x-delayed-type", "direct");
        channel.exchangeDeclare(exchangeName, "x-delayed-message",false, false,map);  //创建路由

        channel.queueDelete(queueName);  //删除队列
        channel.queueDeclare(queueName, true, false, false, null);  //创建队列

        channel.queueBind(queueName, exchangeName, routingKey);  //绑定路由、队列

        channel.close();
        conn.close();


//        String msg = "测试延时de消息|"+ LocalDateTime.now();
//
//        rabbitTemplate.convertAndSend(exchangeName, routingKey, msg, (message) ->{
//            message.getMessageProperties().setHeader("x-delay", 9000); //延迟9秒
//            return message;
//        });

    }
}
