package com.xxfc.platform.order.jobhandler;

import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.common.util.IntervalUtil;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.OrderRentVehicleBiz;
import com.xxfc.platform.order.biz.OrderVehicalCrosstownBiz;
import com.xxfc.platform.order.contant.enumerate.*;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderVehicaleCrosstown;
import com.xxfc.platform.order.pojo.DedDetailDTO;
import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;

/**
 * 跨平台Http任务
 *
 * @author xuxueli 2018-09-16 03:48:34
 */
@JobHandler(value = "rentDepositHandler")
@Component
@Slf4j
public class RentDepositHandler extends IJobHandler {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderVehicalCrosstownBiz crosstownBiz;

    @Autowired
    ThirdFeign thirdFeign;

    @Override
    public ReturnT<String> execute(String idLastNumInterval) throws Exception {
        Map<String, Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
        BigDecimal illegalReserve = new BigDecimal(dictionaryMap.get(APP_ORDER+ "_"+ DictionaryKey.ILLEGAL_RESERVE).getDetail());

        try {
            for(int i = 0; i < 10; i++) {
                if(IntervalUtil.staticIsInTheInterval(String.valueOf(i), idLastNumInterval)) {
                    List<BaseOrder> lists = baseOrderBiz.selectByExample(new Example.Builder(BaseOrder.class)
                            //订单已完成的租车订单
                            .where(WeekendSqls.<BaseOrder>custom().andEqualTo(BaseOrder::getType, OrderTypeEnum.RentVehicle)
                                    .andEqualTo(BaseOrder::getStatus, OrderStatusEnum.ORDER_FINISH)
                                    .andLike(BaseOrder::getId, "%"+ String.valueOf(i))).build());

                    //处理自动退押金
                    for(BaseOrder baseOrder : lists) {
                        OrderRentVehicleDetail orvd = orderRentVehicleBiz.selectOne(new OrderRentVehicleDetail() {{
                            setOrderId(baseOrder.getId());
                        }});
                        //未退还， 进行保留违章预备金 的退还
                        if(RefundStatusEnum.NONE.getCode().equals(baseOrder.getRefundStatus())) {
                            OrderVehicaleCrosstown crosstown = crosstownBiz.selectOne(new OrderVehicaleCrosstown(){{
                                setOrderId(baseOrder.getId());
                                setType(CrosstownTypeEnum.TOUR.getCode());
                            }});
                            BigDecimal refundAmont = crosstown.getRestDeposit().subtract(illegalReserve);
                            List<DedDetailDTO> dddList = JSONUtil.toBean(crosstown.getDedDetail(), List.class);
                            String refundDesc = "退还押金："+ refundAmont.toString()+ "(已扣除 违章预备金："+ illegalReserve.toString();
                            for(DedDetailDTO ddd : dddList) {
                                refundDesc += ", "+ ddd.getDeductions()+ ":"+ ddd.getCost();
                            }
                            refundDesc += ")";
                            //退款子流程: 订单基础，退款描述，退款金额
                            baseOrderBiz.refundSubProcess(baseOrder, refundDesc, refundAmont, RefundTypeEnum.RentVehicle.getCode(), RefundStatusEnum.RESIDUE_ILLEGAL.getCode());
                            //设置剩余
                        }else if(RefundStatusEnum.RESIDUE_ILLEGAL.getCode().equals(baseOrder.getRefundStatus())){
                            //判断是否违章
                                //扣违章的钱
                            //baseOrderBiz.refundSubProcess(baseOrder, refundDesc, refundAmont, RefundTypeEnum.RentVehicle.getCode(), RefundStatusEnum.RESIDUE_ILLEGAL.getCode());
                        }
//                        baseOrderBiz.refundSubProcess(baseOrder, refundDesc, refundAmont);
                    }

                }
            }
            ReturnT returnT = new ReturnT(){{
                setCode(100);
                setMsg("成功");
                setContent(idLastNumInterval);
            }};
            return returnT;
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return FAIL;
        } finally {
            ;
        }
    }

}