package com.xxfc.platform.im.biz;


import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.model.Comment;
import com.xxfc.platform.im.model.Msg;
import com.xxfc.platform.im.model.Praise;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Component
public class MsgBiz {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    UserBiz userBiz;

    /**
     * 获取消息列表
     *
     * @param map
     * @return
     * @throws Exception
     */
    public ObjectRestResponse getMsgList(Map<String, Object> map) throws Exception {
        //获取所有朋友圈
        AppUserDTO appUserDTO = userBiz.getUserInfo();
        if (appUserDTO == null) {
            return ObjectRestResponse.createFailedResult(508, "token is null or invalid");
        }
        Integer page = map.get("page") == null ? 1 : Integer.parseInt(map.get("page").toString());
        Integer limit = map.get("limit") == null ? 10 : Integer.parseInt(map.get("limit").toString());
        PageHelper.startPage(page, limit);
        Query query = null;
        List<Msg> msgList = null;
        if (map.get("type") != null) {
            query = new Query(Criteria.where("body.type").is(Integer.parseInt(map.get("type").toString())));
            msgList = fetchAndAttach(mongoTemplate.find(query, Msg.class, "s_msg"), appUserDTO.getImUserid());
        } else {
            msgList = fetchAndAttach(mongoTemplate.findAll(Msg.class, "s_msg"), appUserDTO.getImUserid());
        }
        PageInfo<Msg> goodPageInfo = new PageInfo<>(msgList);
        return ObjectRestResponse.succ(goodPageInfo);
    }

    public ObjectRestResponse getHotMsgList(Map<String, Object> param) {
        Integer page = param.get("page") == null ? 1 : Integer.parseInt(param.get("page").toString());
        Integer limit = param.get("limit") == null ? 10 : Integer.parseInt(param.get("limit").toString());
        PageHelper.startPage(page, limit);
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, "count.praise"));
        List<Msg> msgList = mongoTemplate.find(query, Msg.class, "s_msg");
        PageInfo<Msg> goodPageInfo = new PageInfo<>(msgList);
        return ObjectRestResponse.succ(goodPageInfo);
    }


    /**
     * 添加评论和点赞
     *
     * @param list
     * @param userId
     * @return
     */
    private List<Msg> fetchAndAttach(List<Msg> list, Integer userId) {
        if (userId == null) {
            return new ArrayList<>();
        }
        for (Msg msg : list) {
            //添加评论
            Query query = new Query(Criteria.where("msgId").is(msg.getMsgId()));
            List<Comment> comments = mongoTemplate.find(query, Comment.class, "s_comment");
            msg.setComments(comments);

            //添加点赞
            List<Praise> praise = mongoTemplate.find(query, Praise.class, "s_praise");
            msg.setPraises(praise);

            msg.setIsPraise(this.exists(userId, msg.getMsgId()) ? 1 : 0);
            msg.setIsCollect(this.existsCollect(userId, msg.getMsgId()) ? 1 : 0);
        }
        return list;
    }

    /**
     * 判断是否点赞
     *
     * @param userId
     * @param msgId
     * @return
     */
    public boolean exists(int userId, ObjectId msgId) {
        Query query = new Query(Criteria.where("msgId").is(msgId).and("userId").is(userId));
        List<Praise> praise = mongoTemplate.find(query, Praise.class, "s_praise");
        return 0 != praise.size();
    }

    /**
     * 判断是否评论
     *
     * @param userId
     * @param msgId
     * @return
     */
    public boolean existsCollect(int userId, ObjectId msgId) {
        Query query = new Query(Criteria.where("msgId").is(msgId).and("userId").is(userId));
        List<Comment> comments = mongoTemplate.find(query, Comment.class, "s_comment");
        return 0 != comments.size();
    }
}
